/*
 * lxssxx-e.9.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <exerrors.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#include <tcvset.h>

#define lxport(port) \
    ((struct lxport_type *) (port))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_post_ssport(void *subtext, void **address,
		 const struct x1f4_nodelink_type *nodelink_data)
{
    int status;
    void *ssport;

    status = x1f4_line_ssport(subtext, &ssport);
    if (status) {
    } else {
	void *pset;
	const void *text;

	pset = lock_exlist(ssport)->pset;
	text = lock_exlist(ssport)->text;

	status = tccase(text)->push
	    (&pset, &text, nodelink_data, (void *) &lxport(subtext)->link_m);
	if (status) {
	    status = X1f4_EX_CRITICAL;

	    _libx1f4i0_lxport_side_ssxx(subtext, ssport);
	} else {
	    *address = ssport;

	    lock_exlist(ssport)->pset = pset;
	    lock_exlist(ssport)->text = text;
	}
    }

    return status;
}
