/*
 * lxssxx-a.b.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <exerrors.h>
#include <lxdata.h>
#include <lxdate.h>
#include <lxfset.h>
#include <lxlist.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#include <nl.h>
#include <tcvset.h>

#define lxport(list) \
    ((struct lxport_type *) (list))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

static int line_s010(struct lxport_type *, void *,
		     struct ssport_type *, const struct ssport_type *);
static int line_s030(struct lxport_type *, void *,
		     struct ssport_type *, const struct ssport_type *);
static int line_s050(struct lxport_type *, void *,
		     struct ssport_type *, const struct ssport_type *);
static int line_s070(struct lxport_type *, void *,
		     struct ssport_type *, const struct ssport_type *);

static int
line_s010(struct lxport_type *lxport_data, void *bqpp,
	  struct ssport_type *ssport_data,
	  const struct ssport_type *ssport_text)
{
    int status;
    void *wait;

    status = x1f4_fare_lxtime
	(lxport_data->link_l.date, bqpp, &wait, ssport_text->wait,
	 lock_excase(ssport_data));
    if (status) {
    } else {
	if (0) {
	    x1f4_flat_lxtime(lxport_data->link_l.date, &wait);
	} else {
	    ssport_data->wait = wait;
	}
    }

    return status;
}


static int
line_s030(struct lxport_type *lxport_data, void *bqpp,
	  struct ssport_type *ssport_data,
	  const struct ssport_type *ssport_text)
{
    int status;
    void *path;

    status = x1f4_fare_lxdata
	(lxport_data->link_l.data, bqpp, &path, ssport_text->path,
	 lock_excase(ssport_data));
    if (status) {
    } else {
	status = line_s010(lxport_data, bqpp, ssport_data, ssport_text);
	if (status) {
	    x1f4_flat_lxdata(lxport_data->link_l.data, &path);
	} else {
	    ssport_data->path = path;
	}
    }

    return status;
}


static int
line_s050(struct lxport_type *lxport_data, void *bqpp,
	  struct ssport_type *ssport_data,
	  const struct ssport_type *ssport_text)
{
    int status;
    void *read;

    status = x1f4_fare_lxdata
	(lxport_data->link_l.data, bqpp, &read, ssport_text->read,
	 lock_excase(ssport_data));
    if (status) {
    } else {
	status = line_s030(lxport_data, bqpp, ssport_data, ssport_text);
	if (status) {
	    x1f4_flat_lxdata(lxport_data->link_l.data, &read);
	} else {
	    ssport_data->read = read;
	}
    }

    return status;
}


static int
line_s070(struct lxport_type *lxport_data, void *bqpp,
	  struct ssport_type *ssport_data,
	  const struct ssport_type *ssport_text)
{
    int status;
    void *argv;

    status = x1f4_fare_lxlist
	(lxport_data->link_l.list, bqpp, &argv, ssport_text->argv,
	 lock_excase(ssport_data));
    if (status) {
    } else {
	status = line_s050(lxport_data, bqpp, ssport_data, ssport_text);
	if (status) {
	    x1f4_free_lxlist
		(lxport_data->link_l.list, argv, NULL,
		 lock_excase(ssport_data));
	} else {
	    ssport_data->argv = argv;
	}
    }

    return status;
}


int
x1f4_copy_ssport(void *subtext, void *bppp, void **copy, const void *port,
		 const struct x1f4_nodelink_type *nodelink_data)
{
    int status;
    struct lxport_type *lxport_data;
    void *ssport;

    lxport_data = subtext;

    status = lxport_data->link_m.link
	(lxport_data->link_m.data, &ssport, __struct_ssport_type_alloc_size__);
    if (status) {
	status = _libx1f4i0_lxport_stat_link(lxport_data);
    } else {
	void *bqpp;

	do {
	    void *record;

	    if (bppp) {
		bqpp = bppp;
	    } else {
		status = x1f4_init_lxfset(&bqpp);
		if (status) {
		    status = _libx1f4i0_lxport_stat_link(lxport_data);
		    if (1) {
			break;
		    }
		}
	    }

	    status = x1f4_post_lxfset(bqpp, &port, &record);
	    if (status) {
		status = _libx1f4i0_lxport_stat_link(lxport_data);
		if (1) {
		    break;
		}
	    } else {
		void *pset;
		const void *text;

		ssport = pick_dxlist(ssport);

		{
		    {
			void **node;

			node = record;
			node[0] = (void *) port;
			node[1] = ssport;
		    }
		}

		lock_excase(ssport)->nodetype_data =
		    lxport_data->link_s.nodetype;

		lock_excase(ssport)->slip = NULL;

		lock_exlist(ssport)->call = 1;

		_libx1f4i0_init_tcvset(&pset, &text);

		status = tccase(text)->push
		    (&pset, &text, nodelink_data,
		     (void *) &lxport_data->link_m);
		if (status) {
		    status = X1f4_EX_CRITICAL;

		    _libx1f4i0_fini_tcvset
			(&pset, &text, (void *) &lxport_data->link_m);
		} else {
		    lock_exlist(ssport)->pset = pset;
		    lock_exlist(ssport)->text = text;

		    status = line_s070(lxport_data, bqpp, ssport, port);
		    if (status) {
			_libx1f4i0_fini_tcvset
			    (&pset, &text, (void *) &lxport_data->link_m);
		    } else {
			*copy = ssport;

			ssport = NULL;
		    }
		}
	    }
	} while (0);

	if (bqpp) {
	    if (bppp) {
	    } else {
		int excess;

		excess = x1f4_fini_lxfset(&bqpp);
		if (excess) {
		    excess = _libx1f4i0_lxport_stat_free(lxport_data);

		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	}

	if (ssport) {
	    lxport_data->link_m.free
		(lxport_data->link_m.data, lock_cxlist(ssport));
	}
    }

    return status;
}
