/*
 * lxport-v.7.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxport-inter.h>
#include <lxport-types.h>

#define I_PORT(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_PORT(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxport_s_1xshell(void *context, void *output, void **input)
{
    int status;
    struct xsport_type *xsport_data, *xsport_text;

    xsport_data = I_PORT(input[0]);
    xsport_text = I_PORT(input[1]);

    lock_exlist(xsport_text)->call++;

    status = _libx1f4i0_lxport_side_xsxx(context, xsport_data);
    if (status) {
	lock_exlist(xsport_text)->call--;
	_libx1f4i0_lxport_link_xsxx(context, input[0]);
    } else {
	l_PORT(xsport_text, input[0]);
	l_PORT(xsport_text, output);
    }

    return status;
}
