/*
 * lxport-types.h
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxport_types_H__
#define __LIBx1f4_lxport_types_H__

#include <config.h>

#include <lxport-config.h>

#include <sys/types.h>

#include <dt.h>
#include <ln.h>
#include <nt.h>
#if __TRANS_PORT_LX_DEFINITION__
# include <trans.h>
#endif				/* __TRANS_PORT_LX_DEFINITION__ */

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#define here_NULL			((void *) 0)

#define here_offsetof(type, ceil) \
    ((integral_q) (&((type *) here_NULL)->ceil))

#define lock_excase(dxlist_text) \
    ((struct x1f4_nodelink_type *) &lock_cxlist((dxlist_text))->link)

#define lock_exlist(dxlist_text) \
    ((struct x1f4_nodeline_type *) &lock_cxlist((dxlist_text))->line)

#define lock_cxlist(dxlist_text) \
    ((struct x1f4_leadnode_type *)					      \
     ((char *) (dxlist_text) - sizeof(struct x1f4_leadnode_type)))

#define near_dxlist(excase_text) \
    ((struct ssport_type *)						      \
     ((char *) near_cxlist((excase_text)) + sizeof(struct x1f4_leadnode_type)))

#define near_vxlist(excase_text) \
    ((struct xsport_type *)						      \
     ((char *) near_cxlist((excase_text)) + sizeof(struct x1f4_leadnode_type)))

#define near_exlist(excase_text) \
    ((struct x1f4_nodeline_type *) &near_cxlist((excase_text))->line)

#define near_cxlist(excase_text) \
    ((struct x1f4_leadnode_type *)					      \
     ((char *) (excase_text) - here_offsetof(struct x1f4_leadnode_type, link)))

#define pick_dxlist(fxlist_text) \
    ((struct ssport_type *)						      \
     ((char *) (fxlist_text) + sizeof(struct x1f4_leadnode_type)))

#define pick_vxlist(fxlist_text) \
    ((struct xsport_type *)						      \
     ((char *) (fxlist_text) + sizeof(struct x1f4_leadnode_type)))

#define __struct_ssport_type_alloc_size__ \
    sizeof(struct x1f4_leadnode_type) + sizeof(struct ssport_type)

#define __struct_xsport_type_alloc_size__ \
    sizeof(struct x1f4_leadnode_type) + sizeof(struct xsport_type)

typedef struct waitlink_type {
    pid_t port;
    struct waitlink_type *waitlink_last, *waitlink_next;
} waitlink_type;

typedef struct ssport_type {
    void *argv, *path, *read, *wait;
} ssport_type;

typedef struct xsport_type {
    struct waitlink_type waitlink;
    void *argv, *line, *path, *text;
} xsport_type;

/*
 * NOTES
 *
 *.there may be a need for a temporary memory allocator in addition to the
 * permanent memory allocator (the `link_m' one).
 *.there may be a need for a temporary objects destroyer in addition  to the
 * temporary memory allocator.
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxport_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	void *data, *side;
    } link_f;
    struct {
	int data, list;
    } link_i;
    struct {
	void *data, *date, *file, *list;
    } link_l;
#if __TRANS_PORT_LX_DEFINITION__
    struct trans_type link_m;
#else
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
#endif				/* __TRANS_PORT_LX_DEFINITION__ */
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } link_r;
    struct {
	struct x1f4_nodetype_type nodetype[2];
    } link_s;
    struct {
	struct x1f4_datatype_type datatype[3];
    } link_t;
    struct {
	void *wait;
    } link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
    struct {
	int c3rd;
    } link_x;
    struct {
	int (*call) (void *);
	void *back;
    } link_z;
} lxport_type;

typedef struct screen_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	int data, file, list, time;
    } link_i;
    struct {
	int ssxx, xsxx;
    } link_l;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } link_r;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
    struct {
	int c3rd;
    } link_x;
    struct {
	int (*call) (void *);
	void *back;
    } link_z;
} screen_type;

#endif				/* __LIBx1f4_lxport_types_H__ */
