/*
 * lxport-n.3.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxlead.h>
#include <lxport-inter.h>
#include <nt.h>

int
x1f4_type_xsport(struct x1f4_nodetype_type *nodetype_data, int clist3)
{
    nodetype_data->code = clist3;
    nodetype_data->name = "xshell";
    nodetype_data->size = 6;
    nodetype_data->flags = X1f4_LX_LINK_ACCESS | X1f4_LX_PICK_ACCESS;

    nodetype_data->call = x1f4_call_lxlead;
    nodetype_data->copy = x1f4_copy_xsport;
    nodetype_data->dump = x1f4_dump_xsport;
    nodetype_data->free = x1f4_free_xsport;
    nodetype_data->hash = x1f4_hash_xsport;
    nodetype_data->lead = x1f4_lead_xsport;
    nodetype_data->miss = x1f4_near_lxlead;
    nodetype_data->move = x1f4_move_xsport;
    nodetype_data->node = x1f4_node_xsport;
    nodetype_data->pick = x1f4_pick_xsport;
    nodetype_data->post = NULL;
    nodetype_data->push = x1f4_push_xsport;
    nodetype_data->slip = x1f4_slip_xsport;

    return 0;
}
