/*
 * lxport-inter.h
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxport_inter_H__
#define __LIBx1f4_lxport_inter_H__

/*
 * NOTES
 *
 *.the _null_ method is not similar to the _decq_ and _list_ _null_ methods.
 *.there exists some duplicated _fini_, _null_, _free_ sequences.  better not
 * be duplicated further.
 */

#include <cl.h>
#include <dt.h>
#include <e4.h>
#include <lxport-types.h>
#include <lxwide.h>
#include <nl.h>
#include <nt.h>
#include <trans.h>

#define _libx1f4i0_lxport_bset_port	x1f4_bset_lxport
#define _libx1f4i0_lxport_clip_port	x1f4_clip_lxport
#define _libx1f4i0_lxport_copy_ssxx	x1f4_copy_ssport
#define _libx1f4i0_lxport_copy_xsxx	x1f4_copy_xsport
#define _libx1f4i0_lxport_dset_port	x1f4_dset_lxport
#define _libx1f4i0_lxport_dump_ssxx	x1f4_dump_ssport
#define _libx1f4i0_lxport_dump_xsxx	x1f4_dump_xsport
#define _libx1f4i0_lxport_fini_port	x1f4_fini_lxport
#define _libx1f4i0_lxport_flat_ssxx	x1f4_flat_ssport
#define _libx1f4i0_lxport_flat_xsxx	x1f4_flat_xsport
#define _libx1f4i0_lxport_free_ssxx	x1f4_free_ssport
#define _libx1f4i0_lxport_free_xsxx	x1f4_free_xsport
#define _libx1f4i0_lxport_fset_port	x1f4_fset_lxport
#define _libx1f4i0_lxport_hash_ssxx	x1f4_hash_ssport
#define _libx1f4i0_lxport_hash_xsxx	x1f4_hash_xsport
#define _libx1f4i0_lxport_init_port	x1f4_init_lxport
#define _libx1f4i0_lxport_jack_port	x1f4_jack_lxport
#define _libx1f4i0_lxport_lead_ssxx	x1f4_lead_ssport
#define _libx1f4i0_lxport_lead_xsxx	x1f4_lead_xsport
#define _libx1f4i0_lxport_line_ssxx	x1f4_line_ssport
#define _libx1f4i0_lxport_line_xsxx	x1f4_line_xsport
#define _libx1f4i0_lxport_link_ssxx	x1f4_link_ssport
#define _libx1f4i0_lxport_link_xsxx	x1f4_link_xsport
#define _libx1f4i0_lxport_move_ssxx	x1f4_move_ssport
#define _libx1f4i0_lxport_move_xsxx	x1f4_move_xsport
#define _libx1f4i0_lxport_near_port	x1f4_near_lxport
#define _libx1f4i0_lxport_node_ssxx	x1f4_node_ssport
#define _libx1f4i0_lxport_node_xsxx	x1f4_node_xsport
#define _libx1f4i0_lxport_pick_ssxx	x1f4_pick_ssport
#define _libx1f4i0_lxport_pick_xsxx	x1f4_pick_xsport
#define _libx1f4i0_lxport_post_ssxx	x1f4_post_ssport
#define _libx1f4i0_lxport_post_xsxx	x1f4_post_xsport
#define _libx1f4i0_lxport_pull_ssxx	x1f4_pull_ssport
#define _libx1f4i0_lxport_push_ssxx	x1f4_push_ssport
#define _libx1f4i0_lxport_push_xsxx	x1f4_push_xsport
#define _libx1f4i0_lxport_seek_port	x1f4_seek_lxport
#define _libx1f4i0_lxport_slip_ssxx	x1f4_slip_ssport
#define _libx1f4i0_lxport_slip_xsxx	x1f4_slip_xsport
#define _libx1f4i0_lxport_tile_port	x1f4_tile_lxport
#define _libx1f4i0_lxport_type_ssxx	x1f4_type_ssport
#define _libx1f4i0_lxport_type_xsxx	x1f4_type_xsport

extern int _libx1f4i0_lxport_a_1sshell(void *, void *, void **);
extern int _libx1f4i0_lxport_a_1xshell(void *, void *, void **);
extern int _libx1f4i0_lxport_bset_port
    (void *, const struct x1f4_operator_type **);
extern int _libx1f4i0_lxport_clip_port
    (const void *, struct x1f4_nodetype_type **, int *);
extern int _libx1f4i0_lxport_copy_ssxx
    (void *, void *, void **, const void *, const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_copy_xsxx
    (void *, void *, void **, const void *, const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_dset_port
    (void *, const struct x1f4_datatype_type **);
extern int _libx1f4i0_lxport_dump_ssxx(void *, struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_dump_xsxx(void *, struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_f_1xshell(void *, void *, void **);
extern int _libx1f4i0_lxport_fine_ssxx(void *, void *);
extern int _libx1f4i0_lxport_fine_xsxx(void *, void *);
extern int _libx1f4i0_lxport_fini_port(void **);
extern int _libx1f4i0_lxport_flat_ssxx(void *, void **);
extern int _libx1f4i0_lxport_flat_xsxx(void *, void **);
extern int _libx1f4i0_lxport_free_ssxx
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_free_xsxx
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_fset_port
    (void *, const struct x1f4_linetext_type **);
extern int _libx1f4i0_lxport_hash_ssxx
    (void *, struct x1f4_nodelink_type **, struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_hash_xsxx
    (void *, struct x1f4_nodelink_type **, struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_head_ssxx(void *, void *, void **, int);
extern int _libx1f4i0_lxport_heap_ssxx
    (void *, struct x1f4_nodelink_type **, void *);
extern int _libx1f4i0_lxport_heap_xsxx
    (void *, struct x1f4_nodelink_type **, void *);
extern int _libx1f4i0_lxport_init_port
    (void **, unsigned, const struct screen_type *);
extern int _libx1f4i0_lxport_jack_port
    (void *, const struct x1f4_datatype_type *);
extern int _libx1f4i0_lxport_l_1sshell(void *, void *, void **);
extern int _libx1f4i0_lxport_l_1xshell(void *, void *, void **);
extern int _libx1f4i0_lxport_l_2sshell(void *, void *, void **);
extern int _libx1f4i0_lxport_lead_ssxx(void *, void **);
extern int _libx1f4i0_lxport_lead_xsxx(void *, void **);
extern int _libx1f4i0_lxport_line_ssxx(void *, void **);
extern int _libx1f4i0_lxport_line_xsxx(void *, void **);
extern int _libx1f4i0_lxport_link_ssxx(void *, void **);
extern int _libx1f4i0_lxport_link_xsxx(void *, void **);
extern int _libx1f4i0_lxport_move_ssxx
    (void *, void *, const struct x1f4_nodelink_type *,
     const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_move_xsxx
    (void *, void *, const struct x1f4_nodelink_type *,
     const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_near_port(void *);
extern int _libx1f4i0_lxport_node_ssxx
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_node_xsxx
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_null_ssxx
    (void *, struct x1f4_nodelink_type **, void *);
extern int _libx1f4i0_lxport_null_xsxx
    (void *, struct x1f4_nodelink_type **, void *);
extern int _libx1f4i0_lxport_p_1sshell(void *, void *, void **);
extern int _libx1f4i0_lxport_p_1xshell(void *, void *, void **);
extern int _libx1f4i0_lxport_p_2xshell(void *, void *, void **);
extern int _libx1f4i0_lxport_p_3xshell(void *, void *, void **);
extern int _libx1f4i0_lxport_pick_ssxx
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_pick_xsxx
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_post_ssxx
    (void *, void **, const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_pull_ssxx
    (void *, void *, void *, const void *, struct trans_type *,
     struct x1f4_caselink_type **);
extern int _libx1f4i0_lxport_push_ssxx
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_push_xsxx
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int _libx1f4i0_lxport_r_1sshell(void *, void *, void **);
extern int _libx1f4i0_lxport_r_1xshell(void *, void *, void **);
extern int _libx1f4i0_lxport_s_1sshell(void *, void *, void **);
extern int _libx1f4i0_lxport_s_1xshell(void *, void *, void **);
extern int _libx1f4i0_lxport_seek_port(const void *);
extern int _libx1f4i0_lxport_side_ssxx(void *, void *);
extern int _libx1f4i0_lxport_side_xsxx(void *, void *);
extern int _libx1f4i0_lxport_slip_ssxx(void *, void **);
extern int _libx1f4i0_lxport_slip_xsxx(void *, void **);
extern int _libx1f4i0_lxport_stat_free(void *);
extern int _libx1f4i0_lxport_stat_link(void *);
extern int _libx1f4i0_lxport_stat_live(void *, void *);
extern int _libx1f4i0_lxport_stat_mode(void *);
extern int _libx1f4i0_lxport_stat_null(void *);
extern int _libx1f4i0_lxport_stat_text(void *);
extern int _libx1f4i0_lxport_tile_port
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int _libx1f4i0_lxport_type_ssxx(struct x1f4_nodetype_type *, int);
extern int _libx1f4i0_lxport_type_xsxx(struct x1f4_nodetype_type *, int);
extern int _libx1f4i0_lxport_w_1sshell(void *, void *, void **);
extern int _libx1f4i0_lxport_w_1xshell(void *, void *, void **);

#endif				/* __LIBx1f4_lxport_inter_H__ */
