/*
 * lxport-e.k.c
 * Copyright (C) 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxport-defs.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#include <lxwide.h>

static int init_port(void **, unsigned, struct x1f4_lxwide_type *, unsigned,
		     const void *, unsigned, struct screen_type *);

static int
init_port(void **lxport, unsigned bits, struct x1f4_lxwide_type *lxwide_data,
	  unsigned tile, const void *data, unsigned flags,
	  struct screen_type *screen_data)
{
    if (bits & X1f4_LXWIDE_CODELINK) {
	if (flags & CODELINK_LINK) {
	} else {
	    flags |= CODELINK_LINK;
	    screen_data->link_w.data = lxwide_data->codelink_set.data;
	    screen_data->link_w.free = lxwide_data->codelink_set.free;
	    screen_data->link_w.link = lxwide_data->codelink_set.link;
	    screen_data->link_w.mode = lxwide_data->codelink_set.mode;
	}
    }

    if (bits & X1f4_LXWIDE_MISSBAIL) {
	if (flags & MISSBAIL_LINK) {
	} else {
	    flags |= MISSBAIL_LINK;
	    screen_data->link_r.call = lxwide_data->missbail_set.call;
	    screen_data->link_r.fine = lxwide_data->missbail_set.fine;
	    screen_data->link_r.miss = lxwide_data->missbail_set.miss;
	    screen_data->link_r.text = lxwide_data->missbail_set.text;
	}
    }

    if (bits & X1f4_LXWIDE_RESOURCE) {
	if (flags & RESOURCE_LINK) {
	} else {
	    flags |= RESOURCE_LINK;
	    screen_data->link_m.data = lxwide_data->resource_set.data;
	    screen_data->link_m.free = lxwide_data->resource_set.free;
	    screen_data->link_m.link = lxwide_data->resource_set.link;
	    screen_data->link_m.mode = lxwide_data->resource_set.mode;
	}
    }

    if (bits & X1f4_LXWIDE_TEXTFLAT) {
	if (flags & TEXTFLAT_LINK) {
	} else {
	    flags |= TEXTFLAT_LINK;
	    screen_data->link_e.data = lxwide_data->textflat_set.data;
	    screen_data->link_e.line = lxwide_data->textflat_set.line;
	    screen_data->link_e.post = lxwide_data->textflat_set.post;
	    screen_data->link_e.push = lxwide_data->textflat_set.push;
	}
    }

    return _libx1f4i0_lxport_init_port(lxport, flags, screen_data);
}


int
x1f4_tile_lxport(void **lxport, unsigned bits,
		 struct x1f4_lxwide_type *lxwide_data, unsigned tile,
		 const void *data)
{
    int status;

    do {
	int type;
	struct screen_type screen;
	unsigned flags;

	if (data) {
	    screen = *(const struct screen_type *) data;
	}

	flags = tile;

	if (1) {
	    lxwide_data->widetype_set.type++;
	    screen.link_l.ssxx = lxwide_data->widetype_set.type;
	    lxwide_data->widetype_set.type++;
	    screen.link_l.xsxx = lxwide_data->widetype_set.type;
	}

	if (x1f4_mind_lxwide(&type, lxwide_data, "data", 4)) {
	    screen.link_i.data = type;
	} else {
	    status = 1;
	    if (1) {
		break;
	    }
	}

	if (x1f4_mind_lxwide(&type, lxwide_data, "file", 4)) {
	    screen.link_i.file = type;
	} else {
	    status = 1;
	    if (1) {
		break;
	    }
	}

	if (x1f4_mind_lxwide(&type, lxwide_data, "list", 4)) {
	    screen.link_i.list = type;
	} else {
	    status = 1;
	    if (1) {
		break;
	    }
	}

	if (x1f4_mind_lxwide(&type, lxwide_data, "time", 4)) {
	    screen.link_i.time = type;
	} else {
	    status = 1;
	    if (1) {
		break;
	    }
	}

	status = init_port
	    (lxport, bits, lxwide_data, tile, data, flags, &screen);
    } while (0);

    return status;
}
