/*
 * lxport-e.g.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if defined HAVE_LIBx1f4l1
# include <libx1f4l1.h>
#endif				/* HAVE_LIBx1f4l1 */
#include <stddef.h>

#include <e4.h>
#include <exerrors.h>
#include <l_list.h>
#include <lxdata.h>
#include <lxdate.h>
#include <lxlist.h>
#include <lxport-defs.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#if !defined HAVE_LIBx1f4l1
# include <sshell.h>
#endif				/* !HAVE_LIBx1f4l1 */

#define PORT_BITS \
    X1f4_SSHELL_ARGV_MASK | X1f4_SSHELL_C3RD_MASK | X1f4_SSHELL_HEAD_MASK     \
    | X1f4_SSHELL_LINE_MASK | X1f4_SSHELL_LOOK_MASK | X1f4_SSHELL_PATH_MASK   \
    | X1f4_SSHELL_TAIL_MASK | X1f4_SSHELL_TEXT_MASK | X1f4_SSHELL_TYPE_MASK

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_PORT(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	const X1f4_E4_C_TEXT *l;					      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define ssport(port) \
    ((struct ssport_type *) (port))

#define byte(miss)			((unsigned char *) (miss))

typedef struct land_type {
    const char **argv;
    int data;
} land_type;

typedef struct line_type {
    void *data, *text;
} line_type;

static int copy_line(void *, const void *, unsigned);
static int link_port(struct lxport_type *, struct ssport_type *,
		     const char **, int);
static int type_list(void *, void *);

static int
copy_line(void *text, const void *data, unsigned size)
{
    return x1f4_jack_dxdata
	(((struct line_type *) text)->text, ((struct line_type *) text)->data,
	 data, size);
}


static int
link_port(struct lxport_type *lxport_data, struct ssport_type *ssport_data,
	  const char **argv, int miss_exit)
{
    int status;
    void *sshell;

    status = x1f4_init_sshell(&sshell);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	int excess;
	struct line_type line;
	struct x1f4_sshell_type Sshell;
	unsigned bits = PORT_BITS;

	Sshell.channel.line = copy_line;
	Sshell.channel.text = &line;

	if (lxport_data->link_z.call) {
	    Sshell.cleanup.back = lxport_data->link_z.back;
	    Sshell.cleanup.call = lxport_data->link_z.call;

	    bits |= X1f4_SSHELL_BACK_MASK | X1f4_SSHELL_CALL_MASK;
	}

	Sshell.command.argv = argv;
	Sshell.command.path =
	    ((struct x1f4_dxdata_type *) ssport_data->path)->string;

	Sshell.printer.head = lxport_data->link_e.line;
	Sshell.printer.look = lxport_data->link_e.data;
	Sshell.printer.tail = lxport_data->link_e.post;
	Sshell.printer.type = lxport_data->link_e.push;

	if (1) {
	    struct x1f4_dxtime_type *dxtime_data;
	    unsigned second_a, second_f;

	    dxtime_data = ssport_data->wait;

	    second_a = dxtime_data->second_a;
	    second_f = dxtime_data->second_f;
	    if (second_a | second_f) {
		Sshell.timeout.e1st = second_a;
		Sshell.timeout.e6th = second_f;

		bits |= X1f4_SSHELL_E1ST_MASK | X1f4_SSHELL_E6TH_MASK;
	    }
	}

	switch (lxport_data->link_x.c3rd) {
	case LOSE_C3RD:
	    Sshell.trailer.c3rd = X1f4_SSHELL_KILL_C3RD;
	    break;
	case NULL_C3RD:
	    Sshell.trailer.c3rd = X1f4_SSHELL_NULL_C3RD;
	    break;
	default:
	    Sshell.trailer.c3rd = X1f4_SSHELL_MISS_C3RD;
	}

	status = x1f4_mode_sshell(sshell, &Sshell, bits);
	if (status) {
	    status = X1f4_EX_CRITICAL;
	} else {
	    char *data;
	    unsigned size;

	    line.data = ssport_data->read;
	    line.text = lxport_data->link_l.data;

	    status = x1f4_link_sshell(sshell, &data, &size);
	    if (status) {
		status = x1f4_stat_sshell(sshell, status);
		switch (status) {
		case X1f4_SSHELL_LINE_SLIP:
		case X1f4_SSHELL_WAIT_SLIP:
		    status = X1f4_EX_CRITICAL;
		    break;
		default:
		    if (miss_exit) {
			if (status == X1f4_SSHELL_EXIT_SLIP) {
			    status = 0;
			} else {
			    status = X1f4_EX_CAN_CONTINUE;
			}
		    } else {
			status = X1f4_EX_CAN_CONTINUE;
		    }
		}
	    } else {
	    }
	}

	excess = x1f4_fini_sshell(&sshell);
	if (excess) {
	    if (status) {
	    } else {
		status = X1f4_EX_CRITICAL;
	    }
	}
    }

    return status;
}


static int
type_list(void *text, void *data)
{
    int delete;
    struct land_type *land_data;
    unsigned type;

    land_data = text;

    type = byte(data)[0] << 030 | byte(data)[1] << 020 | byte(data)[2] << 010
	| byte(data)[3];
    if (type == X1f4_E4_TEXT) {
	const char **argv;

	argv = land_data->argv;

	*argv = I_TEXT(byte(data) + 8);

	land_data->argv = argv + 1;

	delete = 0;
    } else {
	if (type == land_data->data) {
	    const char **argv;

	    argv = land_data->argv;

	    *argv =
		((struct x1f4_dxdata_type *) I_DATA(byte(data) + 8))->string;

	    land_data->argv = argv + 1;

	    delete = 0;
	} else {
	    delete = 1;
	}
    }

    return delete;
}


int
_libx1f4i0_lxport_head_ssxx(void *context, void *output, void **input,
			    int miss_exit)
{
    int status;
    struct lxport_type *lxport_data;
    struct ssport_type *ssport_data;
    struct x1f4_dxlist_type *dxlist_data;
    unsigned size;

    lxport_data = context;

    ssport_data = I_PORT(input[0]);

    dxlist_data = ssport_data->argv;

    size = dxlist_data->size;

    if (!size) {
	status = _libx1f4i0_lxport_stat_null(lxport_data);
    } else {
	void *text;

	status = lxport_data->link_m.link
	    (lxport_data->link_m.data, &text, (size + 1) * sizeof(char *));
	if (status) {
	    status = _libx1f4i0_lxport_stat_link(lxport_data);
	} else {
	    int excess;
	    struct land_type land;

	    land.argv = text;
	    land.data = lxport_data->link_i.data;

	    status = _libx1f4i0_lime_l4list
		(dxlist_data->list, &land, type_list);
	    if (status) {
		status = _libx1f4i0_lxport_stat_text(lxport_data);
	    } else {
		struct x1f4_dxdata_type *dxdata_data;

		dxdata_data = ssport_data->read;

		*land.argv = NULL;

		status = x1f4_high_dxdata
		    (lxport_data->link_l.data, dxdata_data);
		if (status) {
		} else {
		    status = link_port
			(lxport_data, ssport_data, text, miss_exit);
		    if (status) {
		    } else {
			l_TEXT(dxdata_data->string, output);
		    }
		}
	    }

	    excess = lxport_data->link_m.free(lxport_data->link_m.data, text);
	    if (excess) {
		if (status) {
		} else {
		    status = _libx1f4i0_lxport_stat_free(lxport_data);
		}
	    }
	}
    }

    return status;
}
