/*
 * lxport-a.w.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sys/types.h>
#include <sys/wait.h>

#include <lxport-types.h>

#define lxport(lxport) \
    ((struct lxport_type *) (lxport))

int
x1f4_wait_lxport(void *lxport, pid_t wait)
{
    int status = 0;
    struct waitlink_type *waitlink_data;

    waitlink_data = lxport(lxport)->link_v.wait;
    while (waitlink_data) {
	if (waitlink_data->port ^ wait) {
	} else {
	    waitlink_data->port = -1;

	    status = 1;

	    break;
	}

	waitlink_data = waitlink_data->waitlink_next;
    }

    return status;
}
