/*
 * lxport-a.e.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#include <e4.h>
#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <integral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <l_list.h>
#include <lxdata.h>
#include <lxlist.h>
#include <lxport-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define lxport(lxport) \
    ((struct lxport_type *) (lxport))

#define xsport(port) \
    ((struct xsport_type *) (port))

#define byte(miss)			((unsigned char *) (miss))

typedef struct land_type {
    int (*push) (void *, const char *, unsigned), rate, text;
    void *data;
} land_type;

static int type_line(struct lxport_type *, void *,
		     int (*) (void *, const char *, unsigned),
		     struct x1f4_dxdata_type *, struct x1f4_dxlist_type *);
static int type_list(void *, void *);

static int
type_line(struct lxport_type *lxport_data, void *data,
	  int (*push) (void *, const char *, unsigned),
	  struct x1f4_dxdata_type *dxdata_data,
	  struct x1f4_dxlist_type *dxlist_data)
{
    int status;

    status = push(data, "`", 1);
    if (status) {
    } else {
	status = push(data, dxdata_data->string, dxdata_data->length);
	if (status) {
	} else {
	    status = push(data, "' of ", 5);
	    if (status) {
	    } else {
		struct land_type land;

		land.data = data;
		land.push = push;
		land.rate = 1;
		land.text = lxport_data->link_i.data;

		status = _libx1f4i0_lime_l4list
		    (dxlist_data->list, &land, type_list);
		if (status) {
		} else {
		    status = push(data, " }", 2);
		}
	    }
	}
    }

    return status;
}


static int
type_list(void *text, void *call)
{
    int (*push) (void *, const char *, unsigned), status;
    struct land_type *land_data;
    void *data;

    land_data = text;

    data = land_data->data;
    push = land_data->push;

    if (land_data->rate) {
	land_data->rate = 0;

	status = push(data, "{ ", 2);
    } else {
	status = push(data, ", ", 2);
    }
    if (status) {
    } else {
	unsigned type;

	type = byte(call)[0] << 030 | byte(call)[1] << 020
	    | byte(call)[2] << 010 | byte(call)[3];
	if (type == X1f4_E4_TEXT) {
	    X1f4_E4_C_TEXT text;

	    text = I_TEXT(byte(call) + 8);

	    status = push(data, "`", 1);
	    if (status) {
	    } else {
		status = push(data, text, strlen(text));
		if (status) {
		} else {
		    status = push(data, "'", 1);
		}
	    }
	} else {
	    if (type == land_data->text) {
		struct x1f4_dxdata_type *dxdata_data;

		dxdata_data = I_DATA(byte(call) + 8);

		status = push(data, "`", 1);
		if (status) {
		} else {
		    status = push
			(data, dxdata_data->string, dxdata_data->length);
		    if (status) {
		    } else {
			status = push(data, "'", 1);
		    }
		}
	    } else {
		status = push(data, "?", 1);
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxport_stat_free(void *lxport)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxport(lxport)->link_e.data;

	line = lxport(lxport)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxport(lxport)->link_e.push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = lxport(lxport)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxport_stat_link(void *lxport)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxport(lxport)->link_e.data;

	line = lxport(lxport)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxport(lxport)->link_e.push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = lxport(lxport)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxport_stat_live(void *lxport, void *xsport)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxport(lxport)->link_e.data;

	line = lxport(lxport)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxport(lxport)->link_e.push;
	if (push) {
	    status = push(data, "will not execute ", 17);
	    if (status) {
		break;
	    } else {
		status = type_line
		    (lxport, data, push, xsport(xsport)->path,
		     xsport(xsport)->argv);
		if (status) {
		    break;
		} else {
		    status = push(data, " for previous ", 14);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_dintegral
			    (data, push, xsport(xsport)->waitlink.port);
			if (status) {
			    break;
			} else {
			    status = push(data, " is still running", 17);
			}
		    }
		}
	    }
	}

	post = lxport(lxport)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxport_stat_mode(void *lxport)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxport(lxport)->link_e.data;

	line = lxport(lxport)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxport(lxport)->link_e.push;
	if (push) {
	    status = push(data, "cannot reallocate memory", 24);
	    if (status) {
		break;
	    }
	}

	post = lxport(lxport)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxport_stat_null(void *lxport)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxport(lxport)->link_e.data;

	line = lxport(lxport)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxport(lxport)->link_e.push;
	if (push) {
	    status = push(data, "empty arguments list", 20);
	    if (status) {
		break;
	    }
	}

	post = lxport(lxport)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxport_stat_text(void *lxport)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxport(lxport)->link_e.data;

	line = lxport(lxport)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxport(lxport)->link_e.push;
	if (push) {
	    status = push(data, "non string argument", 19);
	    if (status) {
		break;
	    }
	}

	post = lxport(lxport)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
