/*
 * lxport-a.0.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <e4-m.0.h>
#include <e4.h>
#include <lxcall.h>
#include <lxport-defs.h>
#include <lxport-inter.h>
#include <lxport-types.h>

#define MAKE_SINGLE(a, b)		a

#define screen(screen) \
    ((struct screen_type *) (screen))

#define fb_size()			2

static int init_data(struct lxport_type *, unsigned,
		     const struct screen_type *);
static int line_port(struct lxport_type *, unsigned,
		     const struct screen_type *);
static int line_text(struct lxport_type *, unsigned,
		     const struct screen_type *, void *, void **, void **);
static int link_data(struct lxport_type *, unsigned,
		     const struct screen_type *);

static void line_ssa1(u_case_args_____0);
static void line_ssl1(u_case_args_____0);
static void line_ssl2(u_case_args_____0);
static void line_ssp1(u_case_args_____0);
static void line_ssr1(u_case_args_____0);
static void line_sss1(u_case_args_____0);
static void line_ssw1(u_case_args_____0);
static void line_xsa1(u_case_args_____0);
static void line_xsf1(u_case_args_____0);
static void line_xsl1(u_case_args_____0);
static void line_xsp1(u_case_args_____0);
static void line_xsp2(u_case_args_____0);
static void line_xsp3(u_case_args_____0);
static void line_xsr1(u_case_args_____0);
static void line_xss1(u_case_args_____0);
static void line_xsw1(u_case_args_____0);

static const char fss_setf[] = "ss_set", fxs_setf[] = "xs_set",
    *const side_f[] = {
/* *INDENT-OFF* */
    fss_setf,
    fxs_setf
/* *INDENT-ON* */
};
static const struct line_type ever_line[] = {
/* *INDENT-OFF* */
#define s_set_count			2
    {	{	fss_setf,
		_libx1f4i0_lxport_s_1sshell,	X1f4_E4_VOID,
		NULL,				s_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						6		},
	line_sss1,							},
#define s_set_reach			(0 + (s_set_count << 1))
#define x_set_count			2
    {	{	fxs_setf,
		_libx1f4i0_lxport_s_1xshell,	X1f4_E4_VOID,
		NULL,				x_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						6		},
	line_xss1,							}
#define x_set_reach			(s_set_reach + (x_set_count << 1))
/* *INDENT-ON* */
#define ever_line_count			x_set_reach
}, slip_line[] = {
/* *INDENT-OFF* */
#define s_argv_count			1
    {	{	"ss_argv",
		_libx1f4i0_lxport_a_1sshell,	0,
		NULL,				s_argv_count,
		0,				7		},
	line_ssa1,							},
#define s_argv_reach			(0 + s_argv_count)
#define s_line_count			1
    {	{	"ss_line",
		_libx1f4i0_lxport_l_2sshell,	X1f4_E4_TEXT,
		NULL,				s_line_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					7		},
	line_ssl2,							},
#define s_line_reach			(s_argv_reach + s_line_count)
#define s_link_count			1
    {	{	"ss_link",
		_libx1f4i0_lxport_l_1sshell,	X1f4_E4_TEXT,
		NULL,				s_link_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					7		},
	line_ssl1,							},
#define s_link_reach			(s_line_reach + s_link_count)
#define s_path_count			1
    {	{	"ss_path",
		_libx1f4i0_lxport_p_1sshell,	0,
		NULL,				s_path_count,
		0,				7		},
	line_ssp1,							},
#define s_path_reach			(s_link_reach + s_path_count)
#define s_read_count			1
    {	{	"ss_read",
		_libx1f4i0_lxport_r_1sshell,	0,
		NULL,				s_read_count,
		0,				7		},
	line_ssr1,							},
#define s_read_reach			(s_path_reach + s_read_count)
#define s_wait_count			1
    {	{	"ss_wait",
		_libx1f4i0_lxport_w_1sshell,	0,
		NULL,				s_wait_count,
		0,				7		},
	line_ssw1,							},
#define s_wait_reach			(s_read_reach + s_wait_count)
#define x_argv_count			1
    {	{	"xs_argv",
		_libx1f4i0_lxport_a_1xshell,	0,
		NULL,				x_argv_count,
		0,				7		},
	line_xsa1,							},
#define x_argv_reach			(s_wait_reach + x_argv_count)
#define x_fold_count			2
    {	{	"xs_fold",
		_libx1f4i0_lxport_f_1xshell,	X1f4_E4_VOID,
		NULL,				x_fold_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					7		},
	line_xsf1,							},
#define x_fold_reach			(x_argv_reach + x_fold_count)
#define x_input_count			1
    {	{	"xs_input",
		_libx1f4i0_lxport_w_1xshell,	0,
		NULL,				x_input_count,
		0,				8		},
	line_xsw1,							},
#define x_input_reach			(x_fold_reach + x_input_count)
#define x_lead_count			1
    {	{	"xs_lead",
		_libx1f4i0_lxport_l_1xshell,	X1f4_E4_VOID,
		NULL,				x_lead_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					7		},
	line_xsl1,							},
#define x_lead_reach			(x_input_reach + x_lead_count)
#define x_output_count			1
    {	{	"xs_output",
		_libx1f4i0_lxport_r_1xshell,	0,
		NULL,				x_output_count,
		0,				9		},
	line_xsr1,							},
#define x_output_reach			(x_lead_reach + x_output_count)
#define x_path_count			1
    {	{	"xs_path",
		_libx1f4i0_lxport_p_1xshell,	0,
		NULL,				x_path_count,
		0,				7		},
	line_xsp1,							},
#define x_path_reach			(x_output_reach + x_path_count)
#define x_pid_count			1
    {	{	"xs_pid",
		_libx1f4i0_lxport_p_3xshell,	X1f4_E4_MODE,
		NULL,				x_pid_count,
		0,				6		},
	line_xsp3,							},
#define x_pid_reach			(x_path_reach + x_pid_count)
#define x_pipe_count			2
    {	{	"xs_pipe",
		_libx1f4i0_lxport_p_2xshell,	X1f4_E4_VOID,
		NULL,				x_pipe_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
					7		},
	line_xsp2,							},
#define x_pipe_reach			(x_pid_reach + x_pipe_count)
#define x_read_count			1
    {	{	"xs_read",
		_libx1f4i0_lxport_r_1xshell,	0,
		NULL,				x_read_count,
		0,				7		},
	line_xsr1,							},
#define x_read_reach			(x_pipe_reach + x_read_count)
#define x_write_count			1
    {	{	"xs_write",
		_libx1f4i0_lxport_w_1xshell,	0,
		NULL,				x_write_count,
		0,				8		},
	line_xsw1,							}
#define x_write_reach			(x_read_reach + x_write_count)
/* *INDENT-ON* */
#define slip_line_count			x_write_reach
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					},
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_data(struct lxport_type *lxport_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & CODELINK_LINK) {
	lxport_data->link_w.data = screen_data->link_w.data;
	lxport_data->link_w.free = screen_data->link_w.free;
	lxport_data->link_w.link = screen_data->link_w.link;
	lxport_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxport_data->link_w.data = NULL;
	lxport_data->link_w.free = _x1f4_e4_free_data;
	lxport_data->link_w.link = _x1f4_e4_link_data;
	lxport_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & MISSBAIL_LINK) {
	lxport_data->link_r.call = screen_data->link_r.call;
	lxport_data->link_r.fine = screen_data->link_r.fine;
	lxport_data->link_r.miss = screen_data->link_r.miss;
	lxport_data->link_r.text = screen_data->link_r.text;
    } else {
	lxport_data->link_r.call = NULL;
	lxport_data->link_r.fine = NULL;
	lxport_data->link_r.miss = NULL;
    }

    if (bits & RESOURCE_LINK) {
	lxport_data->link_m.data = screen_data->link_m.data;
	lxport_data->link_m.free = screen_data->link_m.free;
	lxport_data->link_m.link = screen_data->link_m.link;
	lxport_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxport_data->link_m.data = NULL;
	lxport_data->link_m.free = _x1f4_e4_free_data;
	lxport_data->link_m.link = _x1f4_e4_link_data;
	lxport_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & SHUTLINE_LINK) {
	lxport_data->link_z.back = screen_data->link_z.back;
	lxport_data->link_z.call = screen_data->link_z.call;
    } else {
	lxport_data->link_z.back = NULL;
	lxport_data->link_z.call = NULL;
    }

    if (1) {
	lxport_data->link_v.wait = NULL;
    }

    if (1) {
	lxport_data->link_i.data = screen_data->link_i.data;
	lxport_data->link_i.list = screen_data->link_i.list;
    }

    if (bits & TEXTFLAT_LINK) {
	lxport_data->link_e.data = screen_data->link_e.data;
	lxport_data->link_e.line = screen_data->link_e.line;
	lxport_data->link_e.post = screen_data->link_e.post;
	lxport_data->link_e.push = screen_data->link_e.push;
    } else {
	lxport_data->link_e.data = NULL;
	lxport_data->link_e.line = NULL;
	lxport_data->link_e.post = NULL;
	lxport_data->link_e.push = NULL;
    }

    if (bits & THIRDSET_LINK) {
	lxport_data->link_x.c3rd = screen_data->link_x.c3rd;
    } else {
	lxport_data->link_x.c3rd = MISS_C3RD;
    }

    status = link_data(lxport_data, bits, screen_data);

    return status;
}


static int
line_port(struct lxport_type *lxport_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    lxport_data->link_t.datatype[0].context = lxport_data;

    lxport_data->link_t.datatype[0].flat = _libx1f4i0_lxport_flat_ssxx;
    lxport_data->link_t.datatype[0].lead = _libx1f4i0_lxport_lead_ssxx;
    lxport_data->link_t.datatype[0].line = _libx1f4i0_lxport_line_ssxx;
    lxport_data->link_t.datatype[0].link = _libx1f4i0_lxport_link_ssxx;
    lxport_data->link_t.datatype[0].name = "sshell";
    lxport_data->link_t.datatype[0].shut = _libx1f4i0_lxport_flat_ssxx;
    lxport_data->link_t.datatype[0].slip = _libx1f4i0_lxport_slip_ssxx;
    lxport_data->link_t.datatype[0].size = 6;
    lxport_data->link_t.datatype[0].type = screen_data->link_l.ssxx;

    lxport_data->link_s.nodetype[0].context = lxport_data;

    _libx1f4i0_lxport_type_ssxx
	(lxport_data->link_s.nodetype + 0, screen_data->link_l.ssxx);

    lxport_data->link_t.datatype[1].context = lxport_data;

    lxport_data->link_t.datatype[1].flat = _libx1f4i0_lxport_flat_xsxx;
    lxport_data->link_t.datatype[1].lead = _libx1f4i0_lxport_lead_xsxx;
    lxport_data->link_t.datatype[1].line = _libx1f4i0_lxport_line_xsxx;
    lxport_data->link_t.datatype[1].link = _libx1f4i0_lxport_link_xsxx;
    lxport_data->link_t.datatype[1].name = "xshell";
    lxport_data->link_t.datatype[1].shut = _libx1f4i0_lxport_flat_xsxx;
    lxport_data->link_t.datatype[1].slip = _libx1f4i0_lxport_slip_xsxx;
    lxport_data->link_t.datatype[1].size = 6;
    lxport_data->link_t.datatype[1].type = screen_data->link_l.xsxx;

    lxport_data->link_s.nodetype[1].context = lxport_data;

    _libx1f4i0_lxport_type_xsxx
	(lxport_data->link_s.nodetype + 1, screen_data->link_l.xsxx);

    lxport_data->link_t.datatype[2].context = NULL;

    lxport_data->link_t.datatype[2].flat = NULL;
    lxport_data->link_t.datatype[2].lead = NULL;
    lxport_data->link_t.datatype[2].line = NULL;
    lxport_data->link_t.datatype[2].link = NULL;
    lxport_data->link_t.datatype[2].name = NULL;
    lxport_data->link_t.datatype[2].shut = NULL;
    lxport_data->link_t.datatype[2].slip = NULL;
    lxport_data->link_t.datatype[2].size = 0;
    lxport_data->link_t.datatype[2].type = 0;

    return 0;
}


static int
line_text(struct lxport_type *lxport_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args,
	  void **dana)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxport_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxport_data, bits, screen_data, linetext_data, args,
	     sizeof(ever_line) / sizeof(struct line_type), ever_line);
	linetext_data += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
link_data(struct lxport_type *lxport_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_count, line_count;
    void *data;

    args_count = 0;
    line_count = 1;

    {
	args_count += slip_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	args_count += ever_line_count;
	line_count += sizeof(ever_line) / sizeof(struct line_type);
    }

    status = lxport_data->link_w.link
	(lxport_data->link_w.data, &data,
	 line_count * sizeof(struct x1f4_linetext_type)
	 + (sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *))
	 * fb_size() + sizeof(struct x1f4_operator_type *)
	 + args_count * sizeof(int));
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *side;

	side = (struct x1f4_linetext_type *) data + line_count;
	side = (struct tide_type *) side + fb_size();
	args = (struct x1f4_operator_type **) side + fb_size() + 1;

	lxport_data->link_f.data = data;
	lxport_data->link_f.side = side;

	line_text(lxport_data, bits, screen_data, data, &args, &dana);
	_libx1f4i0_lxcall_line_side(side, data, side_o, side_f, fb_size());

	line_port(lxport_data, bits, screen_data);
    }

    return status;
}


static void
line_ssa1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.ssxx;

    *args = line;

    linetext_data->function.type = screen(screen)->link_i.list;
}


static void
line_ssl1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.ssxx;

    *args = line;
}


static void
line_ssl2(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.ssxx;

    *args = line;
}


static void
line_ssp1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.ssxx;

    *args = line;

    linetext_data->function.type = screen(screen)->link_i.data;
}


static void
line_ssr1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.ssxx;

    *args = line;

    linetext_data->function.type = screen(screen)->link_i.data;
}


static void
line_sss1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.ssxx;
    *line++ = screen(screen)->link_l.ssxx;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_l.ssxx;
}


static void
line_ssw1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.ssxx;

    *args = line;

    linetext_data->function.type = screen(screen)->link_i.time;
}


static void
line_xsa1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.xsxx;

    *args = line;

    linetext_data->function.type = screen(screen)->link_i.list;
}


static void
line_xsf1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.xsxx;
    *line++ = screen(screen)->link_i.file;

    *args = line;
}


static void
line_xsl1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.xsxx;

    *args = line;
}


static void
line_xsp1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.xsxx;

    *args = line;

    linetext_data->function.type = screen(screen)->link_i.data;
}


static void
line_xsp2(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.xsxx;
    *line++ = screen(screen)->link_i.file;

    *args = line;
}


static void
line_xsp3(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.xsxx;

    *args = line;
}


static void
line_xsr1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.xsxx;

    *args = line;

    linetext_data->function.type = screen(screen)->link_i.file;
}


static void
line_xss1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.xsxx;
    *line++ = screen(screen)->link_l.xsxx;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_l.xsxx;
}


static void
line_xsw1(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.xsxx;

    *args = line;

    linetext_data->function.type = screen(screen)->link_i.file;
}


int
x1f4_init_lxport(void **lxport, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *data, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &data, sizeof(struct lxport_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_data(data, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, data);
	    } else {
		_x1f4_e4_free_data(text, data);
	    }
	} else {
	    *lxport = data;
	}
    }

    return status;
}
