/*
 * lxnear-p.f.1.c
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#include <ctype.0.h>
#include <e4.h>
#if !defined HAVE_LIBx1f4i0
# include <float.v-pw.h>
# include <float.v.h>
# include <lcardinal.n-fb.h>
# include <lcardinal.n.h>
# include <lcardinal.v-d.h>
# include <lcardinal.v-fb.h>
# include <lcardinal.v-w.h>
# include <lcardinal.v-wfb.h>
# include <lcardinal.v.h>
# include <lintegral.n-fb.h>
# include <lintegral.n.h>
# include <lintegral.v-d.h>
# include <lintegral.v-fb.h>
# include <lintegral.v-w.h>
# include <lintegral.v-wfb.h>
# include <lintegral.v.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxcast.h>
#include <lxnear-defs.h>
#include <lxnear-inter.h>
#include <lxnear-types.h>
#if !defined HAVE_LIBx1f4i0
# include <space.v.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_REAL(t)			(*((X1f4_E4_C_REAL *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

typedef struct deck_type {
    int object_type, (*push) (void *, const char *, unsigned);
    void *data;
} deck_type;

static int near_fill(struct deck_type *, unsigned);
static int rule_line(struct lxtext_type *, const int *, unsigned, void **);
static int rule_news(struct lxtext_type *, const unsigned char **, int,
		     void *);
static int type_away(struct deck_type *, int, int, unsigned, void *);
static int type_base(struct deck_type *, int, int, unsigned, unsigned, void *);
static int type_bill(struct deck_type *, unsigned, unsigned, unsigned *,
		     void *);
static int type_byte(struct deck_type *, int, unsigned, char);
static int type_char(struct deck_type *, int, int, unsigned, void *);
static int type_code(struct deck_type *, int, unsigned, unsigned, void *);
static int type_data(struct deck_type *, int, unsigned, unsigned, void *);
static int type_hill(struct deck_type *, int, unsigned, unsigned, void *);
static int type_lead(struct deck_type *, int, unsigned, void *);
static int type_line(struct lxtext_type *, const int *, unsigned, void **);
static int type_lock(struct deck_type *, int, void *);
static int type_mode(struct deck_type *, unsigned, unsigned, unsigned *,
		     void *);
static int type_news(struct deck_type *, const unsigned char **, int, void *);
static int type_post(struct deck_type *, const unsigned char **, int, void *);
static int type_real(struct deck_type *, unsigned, unsigned, unsigned *,
		     void *);
static int type_text(struct deck_type *, unsigned, unsigned, unsigned *,
		     void *);

static const unsigned c_type_0[] = {
/*
 * .
 *
 *           %                   /
 *
 *
 *
 *
 *                             ~
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000001, 0x00008020, 0x00000000, 0x40000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_1[] = {
/*
 *
 *
 *           %       )           /
 *
 *
 *
 *
 *                             ~
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x00008220, 0x00000000, 0x40000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_2[] = {
/*
 *
 *
 *
 * 0 1 2 3 4 5 6 7 8 9
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff0000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_3[] = {
/*
 *
 *
 *
 *
 *
 *
 *       c d   f     i           o
 *       s         x
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x00000000, 0x00000000, 0x01088258,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_4[] = {
/*
 *
 *
 *
 *
 *
 *
 *   a b c d e f g h i j k l m n o
 * p q r s t u v w x y z
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x00000000, 0x00000000, 0x07fffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_5[] = {
/*
 *
 *
 *
 *
 *
 *
 *     b   d   f
 * p             w x
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x00000000, 0x00000000, 0x01810054,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

static int
near_fill(struct deck_type *deck_data, unsigned w)
{
    return x1f4_vprint_space(deck_data->data, deck_data->push, w);
}


static int
rule_line(struct lxtext_type *lxtext_data, const int *args, unsigned count,
	  void **input)
{
    int c, status = 0;
    unsigned lock = 0;
    const unsigned char *line;

    line = (void *) I_TEXT(input[0]);
    while (1) {
	c = *line++;
	if (C_TYPE_X(c_type_0, c)) {
	    if (c) {
		if (c == '%') {
		    c = *line;
		    if (C_TYPE_X(c_type_1, c)) {
			line++;
		    } else {
			lock++;
			if (lock < count) {
			} else {
			    status = _libx1f4i0_lxnear_stat_lock
				(lxtext_data->text, lock, count);
			    break;
			}
			status = rule_news
			    (lxtext_data, &line, args[lock], input[lock]);
			if (status) {
			    break;
			}
		    }
		} else {
		    if (c == '~') {
			c = *line;
			if (C_TYPE_X(c_type_2, c)) {
			    lock = 0;
			    do {
				lock *= 10;
				lock += c - '0';
				c = *++line;
			    } while (C_TYPE_X(c_type_2, c));
			} else {
			    lock++;
			}
			if (lock < count) {
			} else {
			    status = _libx1f4i0_lxnear_stat_lock
				(lxtext_data->text, lock, count);
			    break;
			}
		    } else {
			c = *line;
			if (C_TYPE_X(c_type_2, c)) {
			    lock = 0;
			    do {
				lock *= 10;
				lock += c - '0';
				c = *++line;
			    } while (C_TYPE_X(c_type_2, c));
			} else {
			    lock++;
			}
			if (lock < count) {
			} else {
			    status = _libx1f4i0_lxnear_stat_lock
				(lxtext_data->text, lock, count);
			    break;
			}
			while (C_TYPE_X(c_type_4, c)) {
			    if (C_TYPE_X(c_type_5, c)) {
				do {
				    c = *++line;
				} while (C_TYPE_X(c_type_2, c));
			    } else {
				c = *++line;
			    }
			}
			if (c == '/') {
			    line++;
			} else {
			    status = _libx1f4i0_lxnear_stat_post
				(lxtext_data->text);
			    break;
			}
		    }
		}
	    } else {
		break;
	    }
	}
    }

    return status;
}


static int
rule_news(struct lxtext_type *lxtext_data, const unsigned char **e, int type,
	  void *call)
{
    int c, status;
    const unsigned char *line;

    line = *e;

    c = *line;

    if (c == '-') {
	c = *++line;
    }

    if (C_TYPE_X(c_type_2, c)) {
	do {
	    c = *++line;
	} while (C_TYPE_X(c_type_2, c));
    }

    if (type == ((struct lxnear_type *) lxtext_data->text)->link_g.type) {
	struct x1f4_dxcast_type *object_data;

	object_data = I_USER(call);
	call = &object_data->data;
	type = object_data->type;
    }

    if (C_TYPE_X(c_type_3, c)) {
	status = 0;
	switch (c) {
	case 'c':
	case 'd':
	case 'f':
	case 'i':
	case 'o':
	case 'x':
	    if (type != X1f4_E4_BILL) {
		if (type != X1f4_E4_MODE) {
		    if (type != X1f4_E4_REAL) {
			status =
			    _libx1f4i0_lxnear_stat_flat(lxtext_data->text, c);
		    }
		}
	    }
	    break;
	default:
	    if (type != X1f4_E4_TEXT) {
		status = _libx1f4i0_lxnear_stat_text(lxtext_data->text);
	    }
	}
	if (1) {
	    *e = line + 1;
	}
    } else {
	status = _libx1f4i0_lxnear_stat_news(lxtext_data->text, c);
    }

    return status;
}


static int
type_away(struct deck_type *deck_data, int type, int left, unsigned w,
	  void *call)
{
    X1f4_E4_C_REAL real;

    if (type == X1f4_E4_REAL) {
	real = I_REAL(call);
    } else {
	if (type == X1f4_E4_BILL) {
	    real = I_BILL(call);
	} else {
	    real = I_MODE(call);
	}
    }

    return x1f4_vprint_pwfloat
	(deck_data->data, deck_data->push, left, w, 0, 88, real);
}


static int
type_base(struct deck_type *deck_data, int type, int left, unsigned w,
	  unsigned x, void *call)
{
    int status;

    if (type == X1f4_E4_BILL) {
	status = type_hill(deck_data, left, w, x, call);
    } else {
	X1f4_E4_C_MODE mode;

	if (type == X1f4_E4_MODE) {
	    mode = I_MODE(call);
	} else {
	    mode = I_REAL(call);
	}

	status = type_code(deck_data, left, w, x, &mode);
    }

    return status;
}


static int
type_bill(struct deck_type *deck_data, unsigned lead, unsigned near,
	  unsigned *seek, void *call)
{
    int status;

    do {
	int left = 0;
	unsigned b = 0, f = 0, w = 0, x = 10;

	if ('w' - 'a' < 32) {
	    if (near & 1 << ('w' - 'a')) {
		w = seek['w' - 'a'];
	    }
	}

	if ('l' - 'a' < 32) {
	    left = lead & 1 << ('l' - 'a');
	}

	if ('c' - 'a' < 32) {
	    if (lead & 1 << ('c' - 'a')) {
		status = type_byte(deck_data, left, w, I_BILL(call));
		if (1) {
		    break;
		}
	    }
	}

	if ('b' - 'a' < 32) {
	    if (near & 1 << ('b' - 'a')) {
		b = seek['b' - 'a'];
	    }
	}

	if ('f' - 'a' < 32) {
	    if (near & 1 << ('f' - 'a')) {
		f = seek['f' - 'a'];
	    }
	}

	if ('x' - 'a' < 32) {
	    if (near & 1 << ('x' - 'a')) {
		x = seek['x' - 'a'];
		if (x < 2 || 36 < x) {
		    status = near_fill(deck_data, w);
		    if (1) {
			break;
		    }
		}
	    }
	}

	if (left) {
	    X1f4_E4_C_BILL bill;

	    bill = I_BILL(call);
	    status = x1f4_vprint_fblcardinal
		(deck_data->data, deck_data->push, 0, f, b, x, bill);
	    if (status) {
	    } else {
		unsigned v = 0;

		x1f4_nprint_fblcardinal(&v, f, b, x, bill);
		if (v < w) {
		    status = x1f4_vprint_space
			(deck_data->data, deck_data->push, w - v);
		}
	    }
	} else {
	    status = x1f4_vprint_wfblcardinal
		(deck_data->data, deck_data->push, 0, w, f, b, x,
		 I_BILL(call));
	}
    } while (0);

    return status;
}


static int
type_byte(struct deck_type *deck_data, int left, unsigned w, char c)
{
    return type_data(deck_data, left, w, 1, &c);
}


static int
type_char(struct deck_type *deck_data, int type, int left, unsigned w,
	  void *call)
{
    char c;

    switch (type) {
    case X1f4_E4_BILL:
	c = I_BILL(call);
	break;
    case X1f4_E4_MODE:
	c = I_MODE(call);
	break;
    default:
	c = I_REAL(call);
	break;
    }

    return type_data(deck_data, left, w, 1, &c);
}


static int
type_code(struct deck_type *deck_data, int left, unsigned w,
	  unsigned x, void *call)
{
    int status;

    do {
#if 0
	if (x < 2) {
	    status = 0;
	    if (1) {
		break;
	    }
	} else {
	    if (36 < x) {
		status = 0;
		if (1) {
		    break;
		}
	    }
	}
#endif				/* 0 */

	if (left) {
	    status = x1f4_vprint_lintegral
		(deck_data->data, deck_data->push, 0, x, I_MODE(call));
	    if (status) {
	    } else {
		unsigned v = 0;

		x1f4_nprint_lintegral(&v, x, I_MODE(call));
		if (v < w) {
		    status = x1f4_vprint_space
			(deck_data->data, deck_data->push, w - v);
		}
	    }
	} else {
	    status = x1f4_vprint_wlintegral
		(deck_data->data, deck_data->push, 0, w, x, I_MODE(call));
	}
    } while (0);

    return status;
}


static int
type_data(struct deck_type *deck_data, int left, unsigned w, unsigned size,
	  void *data)
{
    int status;

    if (size < w) {
	w -= size;
	if (left) {
	    status = deck_data->push(deck_data->data, data, size);
	    if (status) {
	    } else {
		status = x1f4_vprint_space
		    (deck_data->data, deck_data->push, w);
	    }
	} else {
	    status = x1f4_vprint_space
		(deck_data->data, deck_data->push, w);
	    if (status) {
	    } else {
		status = deck_data->push(deck_data->data, data, size);
	    }
	}
    } else {
	status = deck_data->push(deck_data->data, data, size);
    }

    return status;
}


static int
type_hill(struct deck_type *deck_data, int left, unsigned w,
	  unsigned x, void *call)
{
    int status;

    do {
#if 0
	if (x < 2) {
	    status = 0;
	    if (1) {
		break;
	    }
	} else {
	    if (36 < x) {
		status = 0;
		if (1) {
		    break;
		}
	    }
	}
#endif				/* 0 */

	if (left) {
	    status = x1f4_vprint_lcardinal
		(deck_data->data, deck_data->push, 0, x, I_BILL(call));
	    if (status) {
	    } else {
		unsigned v = 0;

		x1f4_nprint_lcardinal(&v, x, I_BILL(call));
		if (v < w) {
		    status = x1f4_vprint_space
			(deck_data->data, deck_data->push, w - v);
		}
	    }
	} else {
	    status = x1f4_vprint_wlcardinal
		(deck_data->data, deck_data->push, 0, w, x, I_BILL(call));
	}
    } while (0);

    return status;
}


static int
type_lead(struct deck_type *deck_data, int left, unsigned w, void *call)
{
    call = I_TEXT(call);

    return type_data(deck_data, left, w, strlen(call), call);
}


static int
type_line(struct lxtext_type *lxtext_data, const int *args, unsigned count,
	  void **input)
{
    int c, status = 0;
    struct deck_type deck;
    unsigned lock = 0;
    const unsigned char *copy, *line;

    deck.data = lxtext_data->data;
    deck.push = lxtext_data->push;

    deck.object_type = ((struct lxnear_type *) lxtext_data->text)->link_g.type;

    line = (void *) I_TEXT(input[0]);

    copy = line;

    while (1) {
	c = *line;
	if (C_TYPE_X(c_type_0, c)) {
	    if (copy != line) {
		status = deck.push(deck.data, (void *) copy, line - copy);
		if (status) {
		    break;
		}
	    }
	    line++;
	    if (c) {
		if (c == '%') {
		    c = *line;
		    if (C_TYPE_X(c_type_1, c)) {
			status = deck.push(deck.data, (void *) line, 1);
			if (status) {
			    break;
			} else {
			    line++;
			}
		    } else {
			lock++;
			status = type_news
			    (&deck, &line, args[lock], input[lock]);
			if (status) {
			    break;
			}
		    }
		} else {
		    if (c == '~') {
			c = *line;
			if (C_TYPE_X(c_type_2, c)) {
			    lock = 0;
			    do {
				lock *= 10;
				lock += c - '0';
				c = *++line;
			    } while (C_TYPE_X(c_type_2, c));
			} else {
			    lock++;
			}
			status = type_lock(&deck, args[lock], input[lock]);
			if (status) {
			    break;
			}
		    } else {
			c = *line;
			if (C_TYPE_X(c_type_2, c)) {
			    lock = 0;
			    do {
				lock *= 10;
				lock += c - '0';
				c = *++line;
			    } while (C_TYPE_X(c_type_2, c));
			} else {
			    lock++;
			}
			status = type_post
			    (&deck, &line, args[lock], input[lock]);
			if (status) {
			    break;
			}
			if (1) {
			    line++;
			}
		    }
		}
	    } else {
		break;
	    }

	    copy = line;
	} else {
	    line++;
	}
    }

    return status;
}


static int
type_lock(struct deck_type *deck_data, int type, void *call)
{
    int status;

    if (type == deck_data->object_type) {
	struct x1f4_dxcast_type *object_data;

	object_data = I_USER(call);
	call = &object_data->data;
	type = object_data->type;
    }

    switch (type) {
    case X1f4_E4_BILL:
	status = x1f4_vprint_dlcardinal
	    (deck_data->data, deck_data->push, I_BILL(call));
	break;
    case X1f4_E4_MODE:
	status = x1f4_vprint_dlintegral
	    (deck_data->data, deck_data->push, I_MODE(call));
	break;
    case X1f4_E4_REAL:
	status = x1f4_vprint_float
	    (deck_data->data, deck_data->push, 077, I_REAL(call));
	break;
    case X1f4_E4_TEXT:
	call = I_TEXT(call);
	status = deck_data->push(deck_data->data, call, strlen(call));
    default:
	status = 0;
    }

    return status;
}


static int
type_mode(struct deck_type *deck_data, unsigned lead, unsigned near,
	  unsigned *seek, void *call)
{
    int status;

    do {
	int left = 0;
	unsigned b = 0, f = 0, w = 0, x = 10;

	if ('w' - 'a' < 32) {
	    if (near & 1 << ('w' - 'a')) {
		w = seek['w' - 'a'];
	    }
	}

	if ('l' - 'a' < 32) {
	    left = lead & 1 << ('l' - 'a');
	}

	if ('c' - 'a' < 32) {
	    if (lead & 1 << ('c' - 'a')) {
		status = type_byte(deck_data, left, w, I_MODE(call));
		if (1) {
		    break;
		}
	    }
	}

	if ('b' - 'a' < 32) {
	    if (near & 1 << ('b' - 'a')) {
		b = seek['b' - 'a'];
	    }
	}

	if ('f' - 'a' < 32) {
	    if (near & 1 << ('f' - 'a')) {
		f = seek['f' - 'a'];
	    }
	}

	if ('x' - 'a' < 32) {
	    if (near & 1 << ('x' - 'a')) {
		x = seek['x' - 'a'];
		if (x < 2 || 36 < x) {
		    status = near_fill(deck_data, w);
		    if (1) {
			break;
		    }
		}
	    }
	}

	if (left) {
	    X1f4_E4_C_MODE mode;

	    mode = I_MODE(call);
	    status = x1f4_vprint_fblintegral
		(deck_data->data, deck_data->push, 0, f, b, x, mode);
	    if (status) {
	    } else {
		unsigned v = 0;

		x1f4_nprint_fblintegral(&v, f, b, x, mode);
		if (v < w) {
		    status = x1f4_vprint_space
			(deck_data->data, deck_data->push, w - v);
		}
	    }
	} else {
	    status = x1f4_vprint_wfblintegral
		(deck_data->data, deck_data->push, 0, w, f, b, x,
		 I_MODE(call));
	}
    } while (0);

    return status;
}


static int
type_news(struct deck_type *deck_data, const unsigned char **e, int type,
	  void *call)
{
    int c, left = 0, status;
    unsigned w = 0;
    const unsigned char *line;

    line = *e;

    c = *line;

    if (c == '-') {
	left = 1;
	c = *++line;
    }

    if (C_TYPE_X(c_type_2, c)) {
	do {
	    w *= 10;
	    w += c - '0';
	    c = *++line;
	} while (C_TYPE_X(c_type_2, c));
    }

    if (type == deck_data->object_type) {
	struct x1f4_dxcast_type *object_data;

	object_data = I_USER(call);
	call = &object_data->data;
	type = object_data->type;
    }

    *e = line + 1;

    switch (c) {
    case 'c':
	status = type_char(deck_data, type, left, w, call);
	break;
    case 'd':
    case 'i':
	status = type_base(deck_data, type, left, w, 10, call);
	break;
    case 'f':
	status = type_away(deck_data, type, left, w, call);
	break;
    case 'o':
	status = type_base(deck_data, type, left, w, 8, call);
	break;
    case 'x':
	status = type_base(deck_data, type, left, w, 16, call);
	break;
    default:
	status = type_lead(deck_data, left, w, call);
    }

    return status;
}


static int
type_post(struct deck_type *deck_data, const unsigned char **e, int type,
	  void *call)
{
    int c, status;
    unsigned lead = 0, near = 0, seek[32];
    const unsigned char *line;

    line = *e;

    c = *line;
    while (C_TYPE_X(c_type_4, c)) {
	if (C_TYPE_X(c_type_5, c)) {
	    int e;

	    c -= 'a';
	    e = *++line;
	    if (C_TYPE_X(c_type_2, e)) {
		unsigned miss = 0;

		do {
		    miss *= 10;
		    miss += e - '0';
		    e = *++line;
		} while (C_TYPE_X(c_type_2, e));

		if (c < 32) {
		    lead |= 1 << c;
		    near |= 1 << c;
		    seek[c] = miss;
		}
	    } else {
		if (c < 32) {
		    lead |= 1 << c;
		    near &= ~(1 << c);
		}
	    }

	    c = e;
	} else {
	    c -= 'a';
	    if (c < 32) {
		lead |= 1 << c;
	    }

	    c = *++line;
	}
    }

    *e = line;

    if (type == deck_data->object_type) {
	struct x1f4_dxcast_type *object_data;

	object_data = I_USER(call);
	call = &object_data->data;
	type = object_data->type;
    }

    switch (type) {
    case X1f4_E4_BILL:
	status = type_bill(deck_data, lead, near, seek, call);
	break;
    case X1f4_E4_MODE:
	status = type_mode(deck_data, lead, near, seek, call);
	break;
    case X1f4_E4_REAL:
	status = type_real(deck_data, lead, near, seek, call);
	break;
    case X1f4_E4_TEXT:
	status = type_text(deck_data, lead, near, seek, call);
    default:
	status = 0;
    }

    return status;
}


static int
type_real(struct deck_type *deck_data, unsigned lead, unsigned near,
	  unsigned *seek, void *call)
{
    int status;

    do {
	int left = 0;
	unsigned d = 0, p = 0, w = 0;

	if ('w' - 'a' < 32) {
	    if (near & 1 << ('w' - 'a')) {
		w = seek['w' - 'a'];
	    }
	}

	if ('l' - 'a' < 32) {
	    left = lead & 1 << ('l' - 'a');
	}

	if ('c' - 'a' < 32) {
	    if (lead & 1 << ('c' - 'a')) {
		status = type_byte(deck_data, left, w, I_REAL(call));
		if (1) {
		    break;
		}
	    }
	}

	if ('d' - 'a' < 32) {
	    if (near & 1 << ('d' - 'a')) {
		d = seek['d' - 'a'];
	    }
	}

	if ('p' - 'a' < 32) {
	    if (near & 1 << ('p' - 'a')) {
		p = seek['p' - 'a'];
	    }
	}

	status = x1f4_vprint_pwfloat
	    (deck_data->data, deck_data->push, left, w, p, d, I_REAL(call));
    } while (0);

    return status;
}


static int
type_text(struct deck_type *deck_data, unsigned lead, unsigned near,
	  unsigned *seek, void *call)
{
    int left = 0;
    unsigned w = 0;

    if ('w' - 'a' < 32) {
	if (near & 1 << ('w' - 'a')) {
	    w = seek['w' - 'a'];
	}
    }

    if ('l' - 'a' < 32) {
	left = lead & 1 << ('l' - 'a');
    }

    call = I_TEXT(call);

    return type_data(deck_data, left, w, strlen(call), call);
}


int
_libx1f4i0_lxnear_f1pending(void *context, void *output, void **input)
{
    const int *args;
    int status = 0;
    struct x1f4_function_type *function_data;
    struct lxtext_type *lxtext_data;
    unsigned count;
    void **side;

    side = context;

    lxtext_data = *side;

    function_data = side[1];

    args = function_data->args;

    count = function_data->count;

    if (lxtext_data->bits & TYPED_TEXT) {
	lxtext_data->lead[1] = I_USER(input[0]);
	args++;
	input++;
	count--;
    }

    status = rule_line(lxtext_data, args, count, input);
    if (status) {
    } else {
	status = type_line(lxtext_data, args, count, input);
    }

    return status;
}
