/*
 * lxnear-l.e.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#include <e4.h>
#include <lxnear-defs.h>
#include <lxnear-types.h>
#if !defined HAVE_LIBx1f4i0
# include <sstring.v.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

extern const unsigned _libx1f4i0_escapes[];

int
_libx1f4i0_lxnear_e_logique(void *context, void *output, void **input)
{
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    if (lxtext_data->bits & TYPED_TEXT) {
	lxtext_data->lead[1] = I_USER(input[0]);
	input++;
    }

    return x1f4_vprint_sstring
	(lxtext_data->data, lxtext_data->push, I_TEXT(input[0]),
	 _libx1f4i0_escapes);
}
