/*
 * lxnear-a.e.c
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4.h>
#include <exerrors.h>
#include <lxnear-types.h>

#define lxnear(lxnear) \
    ((struct lxnear_type *) (lxnear))

int
_libx1f4i0_lxnear_stat_flat(void *lxnear, int e)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxnear(lxnear)->link_e.data;

	line = lxnear(lxnear)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxnear(lxnear)->link_e.push;
	if (push) {
	    status = push
		(data, "bad type for argument corresponding `%", 38);
	    if (status) {
		break;
	    } else {
		char c;

		c = e;
		status = push(data, &c, 1);
		if (status) {
		    break;
		} else {
		    status = push
			(data, "' (`cardinal', `integer' or `real' expected)",
			 44);
		    if (status) {
			break;
		    } else {
		    }
		}
	    }
	}

	post = lxnear(lxnear)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxnear_stat_lock(void *lxnear, unsigned lock, unsigned class)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxnear(lxnear)->link_e.data;

	line = lxnear(lxnear)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxnear(lxnear)->link_e.push;
	if (push) {
	    status = push(data, "item index in format specification (", 36);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dcardinal(data, push, lock);
		if (status) {
		    break;
		} else {
		    status = push(data, ") outside range ( .. ", 21);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_dcardinal(data, push, class - 1);
			if (status) {
			    break;
			} else {
			    status = push(data, ")", 1);
			    if (status) {
				break;
			    }
			}
		    }
		}
	    }
	}

	post = lxnear(lxnear)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxnear_stat_news(void *lxnear, int news)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxnear(lxnear)->link_e.data;

	line = lxnear(lxnear)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxnear(lxnear)->link_e.push;
	if (push) {
	    status = push(data, "unrecognized formatting directive `", 35);
	    if (status) {
		break;
	    } else {
		char c;

		c = news;
		status = push(data, &c, 1);
		if (status) {
		    break;
		} else {
		    status = push(data, "'", 1);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxnear(lxnear)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxnear_stat_post(void *lxnear)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxnear(lxnear)->link_e.data;

	line = lxnear(lxnear)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxnear(lxnear)->link_e.push;
	if (push) {
	    status = push(data, "unmatched leading `/'", 21);
	    if (status) {
		break;
	    }
	}

	post = lxnear(lxnear)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxnear_stat_text(void *lxnear)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxnear(lxnear)->link_e.data;

	line = lxnear(lxnear)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxnear(lxnear)->link_e.push;
	if (push) {
	    status = push
		(data, "bad type for argument corresponding `%s' (`text' exp"
		 "ected)", 58);
	    if (status) {
		break;
	    }
	}

	post = lxnear(lxnear)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
