/*
 * lxmath-types.h
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxmath_types_H__
#define __LIBx1f4_lxmath_types_H__

#include <config.h>

/*
 * NOTES
 *
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxmath_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	void *data, *side;
    } link_f;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} lxmath_type;

typedef struct screen_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} screen_type;

#endif				/* __LIBx1f4_lxmath_types_H__ */
