/*
 * lxmath-o.c.c
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxmath-inter.h>

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_REAL(t)			(*((X1f4_E4_C_REAL *) (t)))

#define l_REAL(e, output) \
    {									      \
	X1f4_E4_C_REAL *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxmath_j120808_2(void *context, void *output, void **input)
{
    X1f4_E4_C_REAL rate;
    int status = 0;

    rate = I_REAL(input[1]);
    if (rate) {
	l_REAL(I_BILL(input[0]) / rate, output);
    } else {
	status = _libx1f4i0_lxmath_stat_zero(context);
    }

    return status;
}
