/*
 * lxmath-f.6.c
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxmath-inter.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxmath_i120813_2(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE a, b;
    int status = 0;

    a = I_MODE(input[0]);
    b = I_MODE(input[1]);

    if (!a) {
	status = _libx1f4i0_lxmath_stat_zero(context);
    } else {
	if (!b) {
	    status = _libx1f4i0_lxmath_stat_zero(context);
	} else {
	    X1f4_E4_C_MODE v;

#if 0
	    while (1) {
		a = a % b;
		if (!a) {
		    v = b;
		    break;
		} else {
		    b = b % a;
		    if (!b) {
			v = a;
			break;
		    }
		}
	    }
#else
	    if (a < 0) {
		a = -a;
	    }
	    if (b < 0) {
		b = -b;
	    }
	    if (a < b) {
	    } else {
		v = a;
		a = b;
		b = v;
	    }
	    {
		unsigned e = 0;

		v = a | b;
		while (!(v & 1)) {
		    e++;
		    v >>= 1;
		}

		a >>= e;
		b >>= e;

		if (b & 1) {
		    v = -a;
		} else {
		    v = b;
		}
		while (v) {
		    while (!(v & 1)) {
			v >>= 1;
		    }
		    if (0 < v) {
			b = v;
		    } else {
			a = -v;
		    }

		    v = b - a;
		}

		v = b << e;
	    }
#endif				/* 0 */

	    l_MODE(v, output);
	}
    }

    return status;
}
