/*
 * lxmath-a.e.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <float.v.h>
# include <lintegral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxtext-types.h>

#define lxtext(lxtext) \
    ((struct lxtext_type *) (lxtext))

int
_libx1f4i0_lxmath_stat_clip(void *lxtext, double tear, double call)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, "invalid clip range (", 20);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_float(data, push, 16, tear);
		if (status) {
		    break;
		} else {
		    status = push(data, " .. ", 4);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_float(data, push, 16, call);
			if (status) {
			    break;
			} else {
			    status = push(data, ")", 1);
			    if (status) {
				break;
			    }
			}
		    }
		}
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxmath_stat_head(void *lxtext, long tear, long call)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, "invalid clip range (", 20);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dlintegral(data, push, tear);
		if (status) {
		    break;
		} else {
		    status = push(data, " .. ", 4);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_dlintegral(data, push, call);
			if (status) {
			    break;
			} else {
			    status = push(data, ")", 1);
			    if (status) {
				break;
			    }
			}
		    }
		}
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxmath_stat_real(void *lxtext, const char *call, double dieu)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, "domain error for `", 18);
	    if (status) {
		break;
	    } else {
		status = push(data, call, strlen(call));
		if (status) {
		    break;
		} else {
		    status = push(data, "' argument, value was ", 22);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_float(data, push, 16, dieu);
			if (status) {
			    break;
			}
		    }
		}
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxmath_stat_spin(void *lxtext, const char *call, double beta,
			    double fail)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, "domain error for `", 18);
	    if (status) {
		break;
	    } else {
		status = push(data, call, strlen(call));
		if (status) {
		    break;
		} else {
		    status = push(data, "' arguments, values were ", 25);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_float(data, push, 16, beta);
			if (status) {
			    break;
			} else {
			    status = push(data, ", ", 2);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_float
				    (data, push, 16, fail);
				if (status) {
				    break;
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxmath_stat_zero(void *lxtext)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, "division by zero", 16);
	    if (status) {
		break;
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
