/*
 * lxmath-a.0.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-m.0.h>
#include <e4.h>
#include <lxmath-defs.h>
#include <lxmath-inter.h>
#include <lxmath-types.h>

#define MAKE_DOUBLE(a, b)		a b
#define MAKE_SINGLE(a, b)		a

#define nonsense_120808_0		_libx1f4i0_lxmath_j120808_0
#define nonsense_120808_1		_libx1f4i0_lxmath_j120808_1
#define nonsense_120808_2		_libx1f4i0_lxmath_j120808_2
#define nonsense_120808_3		_libx1f4i0_lxmath_j120808_3
#define nonsense_120808_4		_libx1f4i0_lxmath_j120808_4
#define nonsense_120808_5		_libx1f4i0_lxmath_j120808_5
#define nonsense_120808_6		_libx1f4i0_lxmath_j120808_6
#define nonsense_120808_7		_libx1f4i0_lxmath_j120808_7
#define nonsense_120808_8		_libx1f4i0_lxmath_j120808_8
#define nonsense_120809_0		_libx1f4i0_lxmath_i120808_0
#define nonsense_120809_1		_libx1f4i0_lxmath_i120808_1
#define nonsense_120809_2		_libx1f4i0_lxmath_i120808_2
#define nonsense_120809_3		_libx1f4i0_lxmath_i120808_3
#define nonsense_120810_0		_libx1f4i0_lxmath_j120810_0
#define nonsense_120810_1		_libx1f4i0_lxmath_j120810_1
#define nonsense_120810_3		_libx1f4i0_lxmath_j120810_3
#define nonsense_120810_4		_libx1f4i0_lxmath_j120810_4
#define nonsense_120811_0		_libx1f4i0_lxmath_j120811_0
#define nonsense_120811_1		_libx1f4i0_lxmath_j120811_1
#define nonsense_120811_2		_libx1f4i0_lxmath_j120811_2
#define nonsense_120811_3		_libx1f4i0_lxmath_j120811_3
#define nonsense_120811_4		_libx1f4i0_lxmath_j120811_4
#define nonsense_120811_5		_libx1f4i0_lxmath_j120811_5
#define nonsense_120811_6		_libx1f4i0_lxmath_j120811_6
#define nonsense_120811_7		_libx1f4i0_lxmath_j120811_7
#define nonsense_120811_8		_libx1f4i0_lxmath_j120811_8
#define nonsense_120812_0		_libx1f4i0_lxmath_j120812_0
#define nonsense_120812_1		_libx1f4i0_lxmath_j120812_1
#define nonsense_120812_3		_libx1f4i0_lxmath_j120812_3
#define nonsense_120812_4		_libx1f4i0_lxmath_j120812_4
#define nonsense_120813_0		_libx1f4i0_lxmath_i120813_0
#define nonsense_120813_1		_libx1f4i0_lxmath_i120813_1
#define nonsense_120813_2		_libx1f4i0_lxmath_i120813_2
#define nonsense_120813_3		_libx1f4i0_lxmath_i120813_3
#define nonsense_120813_4		_libx1f4i0_lxmath_i120813_4
#define nonsense_120813_5		_libx1f4i0_lxmath_i120813_5
#define nonsense_120813_6		_libx1f4i0_lxmath_i120813_6
#define nonsense_120813_7		_libx1f4i0_lxmath_i120813_7
#define nonsense_120813_8		_libx1f4i0_lxmath_i120813_8

#define size_f() \
    sizeof(text_f) / sizeof(struct x1f4_function_type)

#define size_o() \
    sizeof(line_0) / sizeof(struct x1f4_function_type)

typedef struct tide_type {
    struct x1f4_2ndscope_type tidespan;
    struct x1f4_linetext_type linetext;
    struct x1f4_operator_type operator;
} tide_type;

static int init_math(struct lxmath_type *, unsigned,
		     const struct screen_type *);
static int line_side(struct lxmath_type *, struct tide_type *, void **);
static int line_math(struct lxmath_type *, struct x1f4_linetext_type *);
static int link_math(struct lxmath_type *, unsigned,
		     const struct screen_type *);

static const int c_____b_b[] = {
/* *INDENT-OFF* */
    X1f4_E4_BILL,
    X1f4_E4_BILL,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
}, c_____b_m[] = {
/* *INDENT-OFF* */
    X1f4_E4_BILL,
    X1f4_E4_MODE,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
}, c_____b_r[] = {
/* *INDENT-OFF* */
    X1f4_E4_BILL,
    X1f4_E4_REAL,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
}, c_____m_3[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____m_b[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_BILL,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
}, c_____m_m[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
}, c_____m_r[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_REAL,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
}, c_____r_3[] = {
/* *INDENT-OFF* */
    X1f4_E4_REAL,
    X1f4_E4_REAL,
    X1f4_E4_REAL
/* *INDENT-ON* */
}, c_____r_b[] = {
/* *INDENT-OFF* */
    X1f4_E4_REAL,
    X1f4_E4_BILL,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
}, c_____r_m[] = {
/* *INDENT-OFF* */
    X1f4_E4_REAL,
    X1f4_E4_MODE,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
}, c_____r_r[] = {
/* *INDENT-OFF* */
    X1f4_E4_REAL,
    X1f4_E4_REAL,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
};

static const struct x1f4_2ndscope_type side_2[] = {
/* *INDENT-OFF* */
    {	X1f4_E4_CALL_LINK,
	NULL,			NULL				}
/* *INDENT-ON* */
};
static const struct x1f4_function_type text_f[] = {
/* *INDENT-OFF* */
    {	"Gacos",		nonsense_120809_2,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			5			},
    {	"Garccos",		nonsense_120809_2,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			7			},
    {	"Garcsin",		nonsense_120809_3,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			7			},
    {	"Gasin",		nonsense_120809_3,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			5			},
    {	"acos",			nonsense_120809_0,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			4			},
    {	"arccos",		nonsense_120809_0,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			6			},
    {	"arcsin",		nonsense_120809_1,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			6			},
    {	"asin",			nonsense_120809_1,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			4			},
    {	"fclip",		nonsense_120813_0,
	X1f4_E4_REAL,		c_____r_3,	3,
	X1f4_E4_TEXT_LINK,			5			},
    {	"fmod",			nonsense_120813_1,
	X1f4_E4_REAL,		c_____r_r,	2,
	X1f4_E4_TEXT_LINK,			4			},
    {	"gcd",			nonsense_120813_2,
	X1f4_E4_MODE,		c_____m_m,	2,
	X1f4_E4_TEXT_LINK,			3			},
    {	"iclip",		nonsense_120813_3,
	X1f4_E4_MODE,		c_____m_3,	3,
	X1f4_E4_TEXT_LINK,			5			},
    {	"ln",			nonsense_120813_4,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			2			},
    {	"log",			nonsense_120813_4,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			3			},
    {	"log10",		nonsense_120813_5,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			5			},
    {	"log2",			nonsense_120813_6,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			4			},
    {	"pow",			nonsense_120813_7,
	X1f4_E4_REAL,		c_____r_r,	2,
	X1f4_E4_TEXT_LINK,			3			},
    {	"sqrt",			nonsense_120813_8,
	X1f4_E4_REAL,		c_____r_r,	1,
	X1f4_E4_TEXT_LINK,			4			},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1			}
/* *INDENT-ON* */
};
static const struct x1f4_function_type line_0[] = {
/* *INDENT-OFF* */
    {	"/",			nonsense_120808_0,
	X1f4_E4_BILL,		c_____b_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"/",			nonsense_120808_1,
	X1f4_E4_BILL,		c_____b_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"/",			nonsense_120808_2,
	X1f4_E4_REAL,		c_____b_r,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"/",			nonsense_120808_3,
	X1f4_E4_BILL,		c_____m_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"/",			nonsense_120808_4,
	X1f4_E4_MODE,		c_____m_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"/",			nonsense_120808_5,
	X1f4_E4_REAL,		c_____m_r,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"/",			nonsense_120808_6,
	X1f4_E4_REAL,		c_____r_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"/",			nonsense_120808_7,
	X1f4_E4_REAL,		c_____r_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"/",			nonsense_120808_8,
	X1f4_E4_REAL,		c_____r_r,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"%",			nonsense_120810_0,
	X1f4_E4_BILL,		c_____b_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"%",			nonsense_120810_1,
	X1f4_E4_BILL,		c_____b_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"%",			nonsense_120810_3,
	X1f4_E4_BILL,		c_____m_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"%",			nonsense_120810_4,
	X1f4_E4_MODE,		c_____m_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	1			},
    {	"/=",			nonsense_120811_0,
	X1f4_E4_BILL,		c_____b_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"/=",			nonsense_120811_1,
	X1f4_E4_BILL,		c_____b_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"/=",			nonsense_120811_2,
	X1f4_E4_BILL,		c_____b_r,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"/=",			nonsense_120811_3,
	X1f4_E4_MODE,		c_____m_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"/=",			nonsense_120811_4,
	X1f4_E4_MODE,		c_____m_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"/=",			nonsense_120811_5,
	X1f4_E4_MODE,		c_____m_r,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"/=",			nonsense_120811_6,
	X1f4_E4_REAL,		c_____r_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"/=",			nonsense_120811_7,
	X1f4_E4_REAL,		c_____r_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"/=",			nonsense_120811_8,
	X1f4_E4_REAL,		c_____r_r,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"%=",			nonsense_120812_0,
	X1f4_E4_BILL,		c_____b_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"%=",			nonsense_120812_1,
	X1f4_E4_BILL,		c_____b_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"%=",			nonsense_120812_3,
	X1f4_E4_MODE,		c_____m_b,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			},
    {	"%=",			nonsense_120812_4,
	X1f4_E4_MODE,		c_____m_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						2			}
/* *INDENT-ON* */
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  NULL,		0220,
	X1f4_E4_BILL,		c_____b_b,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("/", " "),  NULL,		0220,
	X1f4_E4_BILL,		c_____b_m,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("/", " "),  NULL,		0220,
	X1f4_E4_REAL,		c_____b_r,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("/", " "),  NULL,		0220,
	X1f4_E4_BILL,		c_____m_b,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("/", " "),  NULL,		0220,
	X1f4_E4_MODE,		c_____m_m,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("/", " "),  NULL,		0220,
	X1f4_E4_REAL,		c_____m_r,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("/", " "),  NULL,		0220,
	X1f4_E4_REAL,		c_____r_b,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("/", " "),  NULL,		0220,
	X1f4_E4_REAL,		c_____r_m,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("/", " "),  NULL,		0220,
	X1f4_E4_REAL,		c_____r_r,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("%", " "),  NULL,		0220,
	X1f4_E4_BILL,		c_____b_b,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("%", " "),  NULL,		0220,
	X1f4_E4_BILL,		c_____b_m,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("%", " "),  NULL,		0220,
	X1f4_E4_BILL,		c_____m_b,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_SINGLE("%", " "),  NULL,		0220,
	X1f4_E4_MODE,		c_____m_m,
	X1f4_E4_E2ND_LINK,	1,
	NULL,			NULL					},
    {	MAKE_DOUBLE("/", "="),  NULL,		0400,
	X1f4_E4_BILL,		c_____b_b,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("/", "="),  NULL,		0400,
	X1f4_E4_BILL,		c_____b_m,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("/", "="),  NULL,		0400,
	X1f4_E4_BILL,		c_____b_r,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("/", "="),  NULL,		0400,
	X1f4_E4_MODE,		c_____m_b,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("/", "="),  NULL,		0400,
	X1f4_E4_MODE,		c_____m_m,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("/", "="),  NULL,		0400,
	X1f4_E4_MODE,		c_____m_r,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("/", "="),  NULL,		0400,
	X1f4_E4_REAL,		c_____r_b,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("/", "="),  NULL,		0400,
	X1f4_E4_REAL,		c_____r_m,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("/", "="),  NULL,		0400,
	X1f4_E4_REAL,		c_____r_r,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("%", "="),  NULL,		0400,
	X1f4_E4_BILL,		c_____b_b,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("%", "="),  NULL,		0400,
	X1f4_E4_BILL,		c_____b_m,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("%", "="),  NULL,		0400,
	X1f4_E4_MODE,		c_____m_b,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					},
    {	MAKE_DOUBLE("%", "="),  NULL,		0400,
	X1f4_E4_MODE,		c_____m_m,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
						2,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_math(struct lxmath_type *lxmath_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & CODELINK_LINK) {
	lxmath_data->link_w.data = screen_data->link_w.data;
	lxmath_data->link_w.free = screen_data->link_w.free;
	lxmath_data->link_w.link = screen_data->link_w.link;
	lxmath_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxmath_data->link_w.data = NULL;
	lxmath_data->link_w.free = _x1f4_e4_free_data;
	lxmath_data->link_w.link = _x1f4_e4_link_data;
	lxmath_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxmath_data->link_e.data = screen_data->link_e.data;
	lxmath_data->link_e.line = screen_data->link_e.line;
	lxmath_data->link_e.post = screen_data->link_e.post;
	lxmath_data->link_e.push = screen_data->link_e.push;
    } else {
	lxmath_data->link_e.data = NULL;
	lxmath_data->link_e.line = NULL;
	lxmath_data->link_e.post = NULL;
	lxmath_data->link_e.push = NULL;
    }

    status = link_math(lxmath_data, bits, screen_data);

    return status;
}


static int
line_side(struct lxmath_type *lxmath_data, struct tide_type *tide_data,
	  void **slip)
{
    const struct x1f4_function_type *function_data;
    struct x1f4_operator_type **operator;
    const struct x1f4_operator_type *operator_data;
    unsigned i;

    operator = (void *) (tide_data + size_o());

    *slip = operator;

    operator_data = side_o;

    function_data = line_0;
    i = size_o();
    for (; i; i--) {
	*operator = &tide_data->operator;

	tide_data->operator = *operator_data;
	tide_data->operator.extension2 = &tide_data->tidespan;
	tide_data->tidespan = side_2[0];
	tide_data->tidespan.line = &tide_data->linetext;
	tide_data->linetext.function = *function_data;
	tide_data->linetext.context = lxmath_data;

	operator_data++;

	function_data++;

	tide_data++;

	operator++;
    }

    *operator = NULL;

    return 0;
}


static int
line_math(struct lxmath_type *lxmath_data,
	  struct x1f4_linetext_type *linetext_data)
{
    const struct x1f4_function_type *function_data;
    unsigned i;

    function_data = text_f;
    i = size_f();
    i--;
    for (; i; i--) {
	linetext_data->context = lxmath_data;
	linetext_data->function = *function_data;
	linetext_data++;
	function_data++;
    }
    {
	linetext_data->context = NULL;
	linetext_data->function = *function_data;
    }

    return 0;
}


static int
link_math(struct lxmath_type *lxmath_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    void *data;

    status = lxmath_data->link_w.link
	(lxmath_data->link_w.data, &data,
	 size_f() * sizeof(struct x1f4_linetext_type)
	 + size_o() * (sizeof(struct tide_type)
		       + sizeof(struct x1f4_operator_type *))
	 + sizeof(struct x1f4_operator_type *));
    if (status) {
	status = LINK_ERROR;
    } else {
	void *slip;

	line_math(lxmath_data, data);

	lxmath_data->link_f.data = data;

	data = (char *) data + size_f() * sizeof(struct x1f4_linetext_type);

	line_side(lxmath_data, data, &slip);

	lxmath_data->link_f.side = slip;
    }

    return status;
}


int
x1f4_init_lxmath(void **lxmath, unsigned bits,
	         const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *data, *text;

    if (bits & CODELINK_LINK) {
	data = screen_data->link_w.data;
	link = screen_data->link_w.link;
    } else {
	data = (void *) 0;
	link = _x1f4_e4_link_data;
    }

    status = link(data, &text, sizeof(struct lxmath_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_math(text, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(data, text);
	    } else {
		_x1f4_e4_free_data(data, text);
	    }
	} else {
	    *lxmath = text;
	}
    }

    return status;
}
