/*
 * lxlist-x.m.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <exerrors.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <trans.h>

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#define dxlist(list) \
    ((struct dxlist_type *) (list))
#define lxlist(list) \
    ((struct lxlist_type *) (list))

#define warp(miss) \
    ((struct warp_type *) (miss))

typedef struct warp_type {
    unsigned delete;
    void *dxlist, *lxlist;
} warp_type;

static int fast_deck(void *, void *);

static int
fast_deck(void *warp, void *slip)
{
    int status;
    struct dxlist_type *dxlist_data;
    void *data;

    dxlist_data = warp(warp)->dxlist;

#if defined __MISSING_TAIL_L_LIST__
    status = _libx1f4i0_push_l4list
	(dxlist_data->list, dxlist_data->size, &data);
#else
    status = _libx1f4i0_tail_l4list(dxlist_data->list, &data);
#endif				/* __MISSING_TAIL_L_LIST__ */
    if (status) {
	status = _libx1f4i0_lxlist_stat_list(warp(warp)->lxlist, status);
    } else {
#define type				X1f4_E4_TEXT

	unsigned link;

	byte(data)[0] = type >> 030;
	byte(data)[1] = type >> 020;
	byte(data)[2] = type >> 010;
	byte(data)[3] = type >> 000;

	link = warp(warp)->delete;

	byte(data)[4] = link >> 030;
	byte(data)[5] = link >> 020;
	byte(data)[6] = link >> 010;
	byte(data)[7] = link >> 000;

	dxlist_data->size++;

	l_TEXT(slip, byte(data) + 8);

#undef type
    }

    return status;
}


int
x1f4_warp_lxlist(void *subtext, void *dxlist, unsigned *last, unsigned post,
		 int *delete, void *back,
		 int (*call) (void *, void *, unsigned *, unsigned,
			      int (*) (void *, void *), struct trans_type *))
{
    int status;

    do {
	unsigned link;

	if (1) {
	    struct lxtext_type *lxtext_data, *lxtext_slip;
	    unsigned miss;

	    lxtext_data = lxlist(subtext)->link_f.text;

	    lxtext_slip = lxtext_data;

	    miss = ((struct lxmiss_type *) lxtext_data - 1)->data.miss;
	    while (miss) {
		if (lxtext_slip->lxtype.code == X1f4_E4_TEXT) {
		    break;
		} else {
		    miss--;
		    lxtext_slip++;
		}
	    }

	    if (miss) {
		link = lxtext_slip - lxtext_data;
	    } else {
		status = X1f4_EX_CRITICAL;
		if (1) {
		    break;
		}
	    }
	}

	if (dxlist(dxlist)->size) {
	    status = _libx1f4i0_lxlist_null_list(subtext, NULL, dxlist);
	    if (status) {
		break;
	    }
	} else {
	    status = 0;
	}

	if (1) {
	    struct warp_type warp;

	    warp.delete = link;
	    warp.dxlist = dxlist;
	    warp.lxlist = subtext;

	    *delete = call
		(back, &warp, last, post, fast_deck, &lxlist(subtext)->link_m);
	}
    } while (0);

    return status;
}
