/*
 * lxlist-v.a.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_a_class_v(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxlist_type *dxlist_data;
	struct lxtext_type *lxtext_data;

	lxtext_data = context;

	dxlist_data = I_LIST(input[0]);

	if (1) {
	    {
		void *slip;

		status = lxtext_data->lxtype.copy
		    (lxtext_data->lxtype.context, NULL, &slip,
		     I_USER(input[1]), lock_excase(dxlist_data));
		if (status) {
		    break;
		} else {
		    unsigned type;
		    void *data;

		    type = lxtext_data->lxtype.code;

#if defined __MISSING_TAIL_L_LIST__
		    status = _libx1f4i0_push_l4list
			(dxlist_data->list, dxlist_data->size, &data);
#else
		    status = _libx1f4i0_tail_l4list(dxlist_data->list, &data);
#endif				/* __MISSING_TAIL_L_LIST__ */
		    if (status) {
			status = _libx1f4i0_lxlist_stat_list
			    (lxtext_data->text, status);

			status = lxtext_data->lxtype.free
			    (lxtext_data->lxtype.context,
			     slip, NULL, lock_excase(dxlist_data));
		    } else {
			unsigned link;

			byte(data)[0] = type >> 030;
			byte(data)[1] = type >> 020;
			byte(data)[2] = type >> 010;
			byte(data)[3] = type >> 000;

			link = lxtext_data
			    - ((struct lxtext_type *)
			       ((struct lxlist_type *)
				lxtext_data->text)->link_f.text);

			byte(data)[4] = link >> 030;
			byte(data)[5] = link >> 020;
			byte(data)[6] = link >> 010;
			byte(data)[7] = link >> 000;

			dxlist_data->size++;

			l_USER(slip, byte(data) + 8);
		    }
		}
	    }
	}
    } while (0);

    return status;
}
