/*
 * lxlist-types.h
 * Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxlist_types_H__
#define __LIBx1f4_lxlist_types_H__

#include <config.h>

#include <lxlist-config.h>

#include <dt.h>
#include <e4.h>
#include <ln.h>
#include <nl.h>
#include <nt.h>
#if __TRANS_LIST_LX_DEFINITION__
# include <trans.h>
#endif				/* __TRANS_LIST_LX_DEFINITION__ */

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#define excase_type			x1f4_nodelink_type
#define exlist_type			x1f4_nodeline_type

#define cxlist_type			x1f4_leadnode_type

#define lxtype_type			x1f4_nodetype_type

#define here_NULL			((void *) 0)

#define here_offsetof(type, ceil) \
    ((integral_q) (&((type *) here_NULL)->ceil))

#define lock_excase(dxlist_text) \
    ((struct excase_type *) &lock_cxlist((dxlist_text))->link)

#define lock_exlist(dxlist_text) \
    ((struct exlist_type *) &lock_cxlist((dxlist_text))->line)

#define lock_cxlist(dxlist_text) \
    ((struct cxlist_type *)						      \
     ((char *) (dxlist_text) - sizeof(struct cxlist_type)))

#define near_dxlist(excase_text) \
    ((struct dxlist_type *)						      \
     ((char *) near_cxlist((excase_text)) + sizeof(struct cxlist_type)))

#define near_exlist(excase_text) \
    ((struct exlist_type *) &near_cxlist((excase_text))->line)

#define near_cxlist(excase_text) \
    ((struct cxlist_type *)						      \
     ((char *) (excase_text) - here_offsetof(struct cxlist_type, link)))

#define pick_dxlist(fxlist_text) \
    ((struct dxlist_type *)						      \
     ((char *) (fxlist_text) + sizeof(struct cxlist_type)))

#define post_dxlist(dxlist_text) \
    ((struct dxlist_type *) (dxlist_text) + 1)

#define __struct_dxlist_type_alloc_size__ \
    sizeof(struct cxlist_type) + sizeof(struct dxlist_type)

typedef struct dxlist_type {
    unsigned size;
    void *list;
} dxlist_type;

typedef struct fxdata_type {
    union {
	X1f4_E4_C_BILL bill;
	X1f4_E4_C_MODE mode;
	X1f4_E4_C_REAL real;
	X1f4_E4_C_TEXT text;
	X1f4_E4_C_USER user;
    } data;
} fxdata_type;

/*
 * NOTES
 *
 *.there may be a need for a temporary memory allocator in addition to the
 * permanent memory allocator (the `link_m' one).
 *.there may be a need for a temporary objects destroyer in addition  to the
 * temporary memory allocator.
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxlist_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	void *data, *rail, *side, *text;
    } link_f;
    struct {
	int type;
    } link_g;
#if __TRANS_LIST_LX_DEFINITION__
    struct trans_type link_m;
#else
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
#endif				/* __TRANS_LIST_LX_DEFINITION__ */
    struct {
	void *node;
    } link_n;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } link_r;
    struct {
	void *fine;
    } link_o;
    struct {
	struct x1f4_datatype_type datatype[2];
    } link_t;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} lxlist_type;

typedef struct lxmiss_type {
    union {
	unsigned miss;
	void *data;
    } data;
} lxmiss_type;

typedef struct lxtext_type {
    struct lxtype_type lxtype;
    void *text;
} lxtext_type;

typedef struct screen_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	int type;
    } link_g;
    struct {
	int type;
    } link_l;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } link_r;
    struct {
	void *fine;
    } link_o;
    struct {
	unsigned miss;
	const void *data;
    } link_t;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} screen_type;

#endif				/* __LIBx1f4_lxlist_types_H__ */
