/*
 * lxlist-t.r.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_r_class_t(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;

    dxlist_data = I_LIST(input[0]);

    do {
	X1f4_E4_C_MODE mode;
	struct lxlist_type *lxlist_data;
	struct lxtext_type *lxtext_data;
	unsigned size;
	void *data;

	lxtext_data = context;

	lxlist_data = lxtext_data->text;

	mode = I_MODE(input[1]);

	size = dxlist_data->size;
	if (mode < -(X1f4_E4_C_MODE) (int) size
	    || !(mode < (X1f4_E4_C_MODE) (int) size)) {
	    status = _libx1f4i0_lxlist_stat_deck(lxlist_data, size, mode);

	    break;
	}

	if (mode < 0) {
	    mode += size;
	}

	status = _libx1f4i0_peek_l4list(dxlist_data->list, mode, &data);
	if (status) {
	    status = _libx1f4i0_lxlist_stat_list(lxlist_data, status);
	} else {
	    struct lxtext_type *lxtext_link;
	    unsigned link;
	    void *slip;

	    status = lxtext_data->lxtype.copy
		(lxtext_data->lxtype.context, NULL, &slip,
		 I_USER(input[2]), lock_excase(dxlist_data));
	    if (status) {
		break;
	    }

	    lxtext_link = lxlist_data->link_f.text;

	    link = byte(data)[4] << 030 | byte(data)[5] << 020
		| byte(data)[6] << 010 | byte(data)[7];

	    if (~link) {
		int (*free) (void *, void *, struct excase_type **,
			     const struct excase_type *);
		struct lxtext_type *lxtext_slip;

		lxtext_slip = lxtext_link + link;

		free = lxtext_slip->lxtype.free;
		if (free) {
		    status = free
			(lxtext_slip->lxtype.context,
			 I_USER(byte(data) + 8), NULL,
			 lock_excase(dxlist_data));
		}
	    }
	    {
#define type				X1f4_E4_TEXT

		byte(data)[0] = type >> 030;
		byte(data)[1] = type >> 020;
		byte(data)[2] = type >> 010;
		byte(data)[3] = type >> 000;

		link = lxtext_data - lxtext_link;

		byte(data)[4] = link >> 030;
		byte(data)[5] = link >> 020;
		byte(data)[6] = link >> 010;
		byte(data)[7] = link >> 000;

		l_TEXT(slip, byte(data) + 8);

#undef type
	    }
	}
    } while (0);

    return status;
}
