/*
 * lxlist-p.t.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_list.h>
#include <lxcall.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <trans.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxlist_t_pending(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE mode;
    int status;
    struct dxlist_type *dxlist_data;
    struct lxlist_type *lxlist_data;
    unsigned size;

    dxlist_data = I_LIST(input[0]);

    lxlist_data = context;

    mode = I_MODE(input[1]);

    size = dxlist_data->size;
    if (mode < -(X1f4_E4_C_MODE) (int) size
	|| !(mode < (X1f4_E4_C_MODE) (int) size)) {
	status = _libx1f4i0_lxlist_stat_deck(lxlist_data, size, mode);
    } else {
	void *data;

	if (mode < 0) {
	    mode += size;
	}

	status = _libx1f4i0_peek_l4list(dxlist_data->list, mode, &data);
	if (status) {
	    status = _libx1f4i0_lxlist_stat_list(lxlist_data, status);
	} else {
	    const char *type;
	    unsigned link;

	    link = byte(data)[4] << 030 | byte(data)[5] << 020
		| byte(data)[6] << 010 | byte(data)[7];
	    if (~link) {
		type = ((struct lxtext_type *)
			lxlist_data->link_f.text + link)->lxtype.name;
	    } else {
		type = x1f4_c1_empty_string;

		if (lxlist_data->link_v.link) {
		    struct trans_type trans;

		    trans.data = lxlist_data->link_v.data;
		    trans.free = lxlist_data->link_v.free;
		    trans.link = lxlist_data->link_v.link;
		    trans.mode = lxlist_data->link_v.mode;

		    link = byte(data)[0] << 030 | byte(data)[1] << 020
			| byte(data)[2] << 010 | byte(data)[3];

		    status = _libx1f4i0_lxcall_line_type
			(&type, link, lxlist_data->trap_e.eelookup_data,
			 &trans);
		    if (status) {
			status = _libx1f4i0_lxlist_stat_link(lxlist_data);
		    }
		}
	    }

	    if (status) {
	    } else {
		l_TEXT((char *) type, output);
	    }
	}
    }

    return status;
}
