/*
 * lxlist-p.e.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

typedef struct edit_type {
    struct dxlist_type *dxlist_data;
    struct lxtext_type *lxtext_data;
} edit_type;

static int miss_node(void *, void *);

static int
miss_node(void *text, void *data)
{
    int status = 0;
    unsigned link;

    link = byte(data)[4] << 030 | byte(data)[5] << 020
	| byte(data)[6] << 010 | byte(data)[7];
    if (~link) {
	int (*free) (void *, void *, struct excase_type **,
		     const struct excase_type *);
	struct lxtext_type *lxtext_link;

	lxtext_link = ((struct edit_type *) text)->lxtext_data + link;

	free = lxtext_link->lxtype.free;
	if (free) {
	    status = free
		(lxtext_link->lxtype.context, I_USER(byte(data) + 8), NULL,
		 lock_excase(((struct edit_type *) text)->dxlist_data));
	    if (1) {
		byte(data)[4] = ~0 >> 030;
		byte(data)[5] = ~0 >> 020;
		byte(data)[6] = ~0 >> 010;
		byte(data)[7] = ~0 >> 000;
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxlist_e_pending(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE head, tail;
    int status;
    struct dxlist_type *dxlist_data;
    unsigned size;

    dxlist_data = I_LIST(input[0]);

    size = dxlist_data->size;

    head = I_MODE(input[1]);
    if (head < -(X1f4_E4_C_MODE) (int) size
	|| !(head < (X1f4_E4_C_MODE) (int) size)) {
	status = _libx1f4i0_lxlist_stat_deck
	    (context, size, head);
    } else {
	tail = I_MODE(input[2]);
	if (tail < -(X1f4_E4_C_MODE) (int) size
	    || !(tail < (X1f4_E4_C_MODE) (int) size)) {
	    status = _libx1f4i0_lxlist_stat_deck
		(context, size, tail);
	} else {
	    struct edit_type edit;
	    void *list;

	    if (head < 0) {
		head += size;
	    }

	    if (tail < 0) {
		tail += size;
	    }

	    list = dxlist_data->list;

	    edit.dxlist_data = dxlist_data;
	    edit.lxtext_data =
		((struct lxlist_type *) context)->link_f.text;

	    if (tail < head) {
		status = _libx1f4i0_over_l4list
		    (list, head, size - 1, &edit, miss_node);
		if (status) {
		} else {
		    status = _libx1f4i0_dash_l4list(list, head, size - 1);
		    if (status) {
		    } else {
			status = _libx1f4i0_over_l4list
			    (list, 0, tail, &edit, miss_node);
			if (status) {
			} else {
			    status = _libx1f4i0_dash_l4list(list, 0, tail);
			    if (status) {
			    } else {
				dxlist_data->size = head - tail - 1;
			    }
			}
		    }
		}
	    } else {
		status = _libx1f4i0_over_l4list
		    (list, head, tail, &edit, miss_node);
		if (status) {
		} else {
		    status = _libx1f4i0_dash_l4list(list, head, tail);
		    if (status) {
		    } else {
			dxlist_data->size = size - 1 - tail + head;
		    }
		}
	    }
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(context, status);
	    }
	}
    }

    return status;
}
