/*
 * lxlist-m.p.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_p_class_m(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE mode;
	struct dxlist_type *dxlist_data;
	struct lxtext_type *lxtext_data;

	lxtext_data = context;

	mode = I_MODE(input[1]);

	dxlist_data = I_LIST(input[0]);
	if (0) {
	} else {
	    unsigned size;

	    size = dxlist_data->size + 1;
	    if (mode < -(X1f4_E4_C_MODE) (int) size
		|| !(mode < (X1f4_E4_C_MODE) (int) size)) {
		status = _libx1f4i0_lxlist_stat_deck
		    (lxtext_data->text, size, mode);

		break;
	    } else {
		if (mode < 0) {
		    mode += size;
		}
	    }
	}

	if (1) {
	    void *data;

	    status = _libx1f4i0_push_l4list(dxlist_data->list, mode, &data);
	    if (status) {
		status =
		    _libx1f4i0_lxlist_stat_list(lxtext_data->text, status);
	    } else {
#define type				X1f4_E4_MODE

		unsigned link;

		byte(data)[0] = type >> 030;
		byte(data)[1] = type >> 020;
		byte(data)[2] = type >> 010;
		byte(data)[3] = type >> 000;

		link = lxtext_data
		    - ((struct lxtext_type *)
		       ((struct lxlist_type *)
			lxtext_data->text)->link_f.text);

		byte(data)[4] = link >> 030;
		byte(data)[5] = link >> 020;
		byte(data)[6] = link >> 010;
		byte(data)[7] = link >> 000;

		dxlist_data->size++;

		l_MODE(I_MODE(input[2]), byte(data) + 8);

#undef type
	    }
	}
    } while (0);

    return status;
}
