/*
 * lxlist-l.o.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_o_logique(void *context, void *output, void **input)
{
    int status = 0;
    struct dxlist_type *dxlist_data;
    unsigned size;

    dxlist_data = I_LIST(input[0]);

    size = dxlist_data->size;

    if (size) {
	X1f4_E4_C_MODE mode;
	int (*miss) (void *), (*peek) (void *, void **),
	    (*push) (void *, void **);
	void *list;

	mode = I_MODE(input[1]);

	if (mode < 0) {
	    mode = -mode;
	    mode %= size;
	    mode = -mode;
	    mode += size;
	} else {
	    mode %= size;
	}

	if (size < mode << 1) {
	    mode = size - mode;
	    miss = _libx1f4i0_slip_l4list;
	    peek = _libx1f4i0_ever_l4list;
	    push = _libx1f4i0_head_l4list;
	} else {
	    miss = _libx1f4i0_mind_l4list;
	    peek = _libx1f4i0_lead_l4list;
	    push = _libx1f4i0_tail_l4list;
	}

	list = dxlist_data->list;

	while (mode) {
	    void *data, *text;

	    --mode;

	    status = push(list, &data);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(context, status);
		if (1) {
		    break;
		}
	    } else {
		status = peek(list, &text);
		if (status) {
		    status =
			_libx1f4i0_lxlist_stat_list(context, status);
		    if (1) {
			break;
		    }
		} else {
		    byte(data)[0] = byte(text)[0];
		    byte(data)[1] = byte(text)[1];
		    byte(data)[2] = byte(text)[2];
		    byte(data)[3] = byte(text)[3];
		    byte(data)[4] = byte(text)[4];
		    byte(data)[5] = byte(text)[5];
		    byte(data)[6] = byte(text)[6];
		    byte(data)[7] = byte(text)[7];

		    *(struct fxdata_type *) (byte(data) + 8) =
			*(struct fxdata_type *) (byte(text) + 8);

		    status = miss(list);
		    if (status) {
			byte(data)[4] = ~0;
			byte(data)[5] = ~0;
			byte(data)[6] = ~0;
			byte(data)[7] = ~0;

			status = _libx1f4i0_lxlist_stat_list
			    (context, status);

			break;
		    }
		}
	    }
	}
    }

    return status;
}
