/*
 * lxlist-l.c.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxlist_c_logique(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data, *dxlist_text;
    void *subtext;

    dxlist_data = I_LIST(input[0]);
    dxlist_text = I_LIST(input[1]);

    subtext = context;

    if (dxlist_data == dxlist_text) {
	status = 0;
    } else {
	void *dxtext;

	status = _libx1f4i0_lxlist_line_list(subtext, &dxtext);
	if (status) {
	} else {
	    status = _libx1f4i0_lxlist_late_list
		(subtext, dxlist_data, dxtext, dxlist_text);
	    if (status) {
	    } else {
		status = _libx1f4i0_lxlist_spin_list
		    (subtext, dxtext, dxlist_data);
	    }

	    if (1) {
		int excess;

		excess = _libx1f4i0_lxlist_flat_list(subtext, &dxtext);
		if (excess) {
		    excess = _libx1f4i0_lxlist_stat_list(subtext, excess);
		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	}
    }

    return status;
}
