/*
 * lxlist-e.z.c
 * Copyright (C) 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <exerrors.h>
#include <lxlist-types.h>

#define I_USER(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define lxlist(lxlist) \
    ((struct lxlist_type *) (lxlist))

#define lxtext(lxtext) \
    ((struct lxtext_type *) (lxtext))

static int slip_land(void *);

static int
slip_land(void *news)
{
    int status;
    void *land, **side;

    side = news;
    land = side[1];
    if (land) {
	struct lxtext_type *lxtext_data;

	lxtext_data = *side;
	status = lxtext_data->lxtype.slip(lxtext_data->lxtype.context, &land);
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxlist_pick_data(void *lxlist, void *dxlist, void *lxtext,
			    void *data)
{
    int status;
    void **mind, *news;

    status = lxlist(lxlist)->link_v.pick
	(lxlist(lxlist)->link_v.data, &mind, slip_land, sizeof(void *) << 1,
	 &news);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	X1f4_E4_C_USER fast;
	void **seek;

	fast = I_USER(data);

	*mind = news;

	seek = news;

	*seek++ = lxtext;

	status = lxtext(lxtext)->lxtype.lead
	    (lxtext(lxtext)->lxtype.context, &fast);
	if (status) {
	    *seek = NULL;
	} else {
	    *seek = fast;

	    status = lxtext(lxtext)->lxtype.free
		(lxtext(lxtext)->lxtype.context, fast, NULL,
		 lock_excase(dxlist));
	}
    }

    return status;
}
