/*
 * lxlist-e.y.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcast.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#define lxlist(lxlist) \
    ((struct lxlist_type *) (lxlist))

typedef struct upcast_type {
    struct x1f4_dxcast_type dxcast;
    union {
	int (*free) (void *, void *), (*slip) (void *, void **);
    } v;
    void *text;
} upcast_type;

extern const char *const x1f4_c1_empty_string;

static int post_data(struct lxlist_type *, struct lxtext_type *, void *,
		     void *);
static int post_text(struct lxlist_type *, void *, void *);
static int slip_data(void *);
static int slip_text(void *);

static int
post_data(struct lxlist_type *lxlist_data, struct lxtext_type *lxtext_data,
	  void *output, void *data)
{
    int status;
    void *cast;
    void **mind;

    status = lxlist_data->link_v.pick
	(lxlist_data->link_v.data, &mind, slip_data,
	 sizeof(struct upcast_type), &cast);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	struct upcast_type *upcast_data;

	upcast_data = cast;

	*mind = cast;

	status = lxtext_data->lxtype.lead
	    (lxtext_data->lxtype.context, (void *) (byte(data) + 8));
	if (status) {
	    upcast_data->v.slip = NULL;
	} else {
	    struct x1f4_dxcast_type *dxcast_data;
	    unsigned type;

	    cast = &upcast_data->dxcast;

	    dxcast_data = cast;

	    type = byte(data)[0] << 030 | byte(data)[1] << 020
		| byte(data)[2] << 010 | byte(data)[3];

	    l_USER(cast, output);

	    dxcast_data->call = 1;
	    dxcast_data->type = type;

	    copy_miss(&dxcast_data->data, type, byte(data) + 8);

	    upcast_data->v.slip = lxtext_data->lxtype.slip;
	    upcast_data->text = lxtext_data->lxtype.context;
	}
    }

    return status;
}


static int
post_text(struct lxlist_type *lxlist_data, void *output, void *data)
{
    int status;
    void *cast;
    void **mind;

    status = lxlist_data->link_v.pick
	(lxlist_data->link_v.data, &mind, slip_text,
	 sizeof(struct upcast_type), &cast);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	struct upcast_type *upcast_data;

	upcast_data = cast;

	*mind = cast;

	if (0) {
	} else {
	    struct x1f4_dxcast_type *dxcast_data;

	    cast = &upcast_data->dxcast;

	    dxcast_data = cast;

	    l_TEXT(cast, output);

	    dxcast_data->call = 1;
	    dxcast_data->type = X1f4_E4_TEXT;

	    copy_miss(&dxcast_data->data, X1f4_E4_TEXT, byte(data) + 8);

	    upcast_data->v.free = lxlist_data->link_m.free;
	    upcast_data->text = lxlist_data->link_m.data;
	}
    }

    return status;
}


static int
slip_data(void *upcast)
{
    int (*slip) (void *, void **), status;
    struct upcast_type *upcast_data;

    upcast_data = upcast;

    slip = upcast_data->v.slip;
    if (slip) {
	status = slip
	    (upcast_data->text, (void *) &upcast_data->dxcast.data);
    } else {
	status = 0;
    }

    return status;
}


static int
slip_text(void *upcast)
{
    int status;
    struct upcast_type *upcast_data;
    void *text;

    upcast_data = upcast;

    text = I_TEXT(&upcast_data->dxcast.data);
    if (text != x1f4_c1_empty_string) {
	status = upcast_data->v.free(upcast_data->text, text);
	if (status) {
	    status = X1f4_EX_CRITICAL;
	}
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxlist_post_data(void *lxlist, void *output, void *data)
{
    int status;

    do {
	struct lxtext_type *lxtext_data;
	unsigned link;
	void *cast;

	link = byte(data)[4] << 030 | byte(data)[5] << 020
	    | byte(data)[6] << 010 | byte(data)[7];

	if (~link) {
	    lxtext_data = lxlist(lxlist)->link_f.text;
	    lxtext_data += link;
	    if (lxtext_data->lxtype.lead) {
		status = post_data(lxlist, lxtext_data, output, data);
		if (1) {
		    break;
		}
	    } else {
		if (lxtext_data->lxtype.code == X1f4_E4_TEXT) {
		    status = post_text(lxlist, output, data);
		    if (1) {
			break;
		    }
		}
	    }
	}

	if (0) {
	} else {
	    unsigned type;

	    type = byte(data)[0] << 030 | byte(data)[1] << 020
		| byte(data)[2] << 010 | byte(data)[3];

	    if (X1f4_E4_LAST < type && type < X1f4_E4_CALL) {
		status = _libx1f4i0_lxlist_stat_lead(lxlist, type);
	    } else {
		status = lxlist(lxlist)->link_v.link
		    (lxlist(lxlist)->link_v.data, &cast,
		     sizeof(struct x1f4_dxcast_type));
		if (status) {
		    status = _libx1f4i0_lxlist_stat_link(lxlist);
		} else {
		    struct x1f4_dxcast_type *dxcast_data;

		    dxcast_data = cast;

		    l_USER(cast, output);

		    dxcast_data->call = 0;
		    dxcast_data->type = type;

		    copy_miss(&dxcast_data->data, type, byte(data) + 8);
		}
	    }
	}
    } while (0);

    return status;
}
