/*
 * lxlist-e.v.c
 * Copyright (C) 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <exerrors.h>
#include <lxlist-types.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define lxlist(lxlist) \
    ((struct lxlist_type *) (lxlist))

extern const char *const x1f4_c1_empty_string;

static int slip_text(void *);

static int
slip_text(void *news)
{
    int status;
    void *text, **side;

    side = news;
    text = side[1];
    if (text != x1f4_c1_empty_string) {
	struct lxlist_type *lxlist_data;

	lxlist_data = *side;
	status = lxlist_data->link_m.free(lxlist_data->link_m.data, text);
	if (status) {
	    status = X1f4_EX_CRITICAL;
	}
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxlist_pick_text(void *lxlist, void *data)
{
    int status;
    void **mind, *news;

    status = lxlist(lxlist)->link_v.pick
	(lxlist(lxlist)->link_v.data, &mind, slip_text, sizeof(void *) << 1,
	 &news);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	void **seek;

	*mind = news;

	seek = news;

	*seek++ = lxlist;

	*seek = I_TEXT(data);
    }

    return status;
}
