/*
 * lxlist-e.l.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcast.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <retain.h>

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_fine_data(void *context, void *output, void *data)
{
    int status;
    struct lxlist_type *lxlist_data;
    void *cast;

    lxlist_data = context;

#if __RETAIN_OBJECT_DATA__
# error see _libx1f4i0_lxlist_post_data
#elif 0
    }
#else
    {
#endif				/* __RETAIN_OBJECT_DATA__ */
	unsigned type;

	type = byte(data)[0] << 030 | byte(data)[1] << 020
	    | byte(data)[2] << 010 | byte(data)[3];

#if __RETAIN_OBJECT_DATA__
	if (0) {
	} else {
#endif				/* __RETAIN_OBJECT_DATA__ */
	    status = lxlist_data->link_v.link
		(lxlist_data->link_v.data, &cast,
		 sizeof(struct x1f4_dxcast_type));
	    if (status) {
		status = _libx1f4i0_lxlist_stat_link(lxlist_data);
	    } else {
		struct x1f4_dxcast_type *dxcast_data;

		dxcast_data = cast;

		l_USER(cast, output);

		dxcast_data->call = 0;
		dxcast_data->type = type;

		copy_miss(&dxcast_data->data, type, byte(data) + 8);
	    }
#if __RETAIN_OBJECT_DATA__
	}
#endif				/* __RETAIN_OBJECT_DATA__ */
    }

    return status;
}
