/*
 * lxlist-e.d.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <cl.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <trans.h>

#define dxlist(list) \
    ((struct dxlist_type *) (list))

int
x1f4_pull_lxlist(void *subtext, void *bqpp, void *dxlist,
		 const void *list, struct trans_type *trans_data,
		 struct x1f4_caselink_type **caselink)
{
    int status;
    void *becca[6];

    becca[0] = subtext;
    becca[1] = NULL;
    becca[2] = dxlist;
    becca[3] = bqpp;
    becca[4] = trans_data;
    becca[5] = *caselink;

    status = _libx1f4i0_line_l4list
	(dxlist(dxlist)->list, dxlist(list)->list,
	 _libx1f4i0_lxlist_copy_link, _libx1f4i0_lxlist_free_link, becca);
    if (status) {
	status = _libx1f4i0_lxlist_stat_list(subtext, status);
    } else {
	dxlist(dxlist)->size = dxlist(list)->size;
    }

    *caselink = becca[5];

    return status;
}
