/*
 * lxlist-e.9.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <exerrors.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <tcvset.h>

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_post_lxlist(void *subtext, void **address,
		 const struct excase_type *excase_data)
{
    int status;
    struct lxlist_type *lxlist_data;
    unsigned call;
    void *dxlist;

    lxlist_data = subtext;

    _libx1f4i0_call_l4list(&call);

    status = lxlist_data->link_m.link
	(lxlist_data->link_m.data, &dxlist,
	 __struct_dxlist_type_alloc_size__ + call);
    if (status) {
	status = _libx1f4i0_lxlist_stat_link(lxlist_data);
    } else {
	dxlist = pick_dxlist(dxlist);

	status = _libx1f4i0_lxlist_fast_list(subtext, dxlist);
	if (status) {
	    lxlist_data->link_m.free
		(lxlist_data->link_m.data, lock_cxlist(dxlist));
	} else {
	    void *pset;
	    const void *text;

	    ((struct dxlist_type *) dxlist)->size = 0;

	    lock_excase(dxlist)->nodetype_data = lxlist_data->link_n.node;

	    lock_excase(dxlist)->slip = NULL;

	    lock_exlist(dxlist)->call = 1;

	    _libx1f4i0_init_tcvset(&pset, &text);

	    status = tccase(text)->push
		(&pset, &text, excase_data, (void *) &lxlist_data->link_m);
	    if (status) {
		status = X1f4_EX_CRITICAL;

		_libx1f4i0_lxlist_side_list(subtext, dxlist);
	    } else {
		*address = dxlist;

		lock_exlist(dxlist)->pset = pset;
		lock_exlist(dxlist)->text = text;
	    }
	}
    }

    return status;
}
