/*
 * lxlist-c.e.1.c
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcast.h>
#include <lxlist-inter.h>

#define l_LIST(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

static int rule_list(struct lxlist_type *, void *, struct x1f4_function_type *,
		     void **);
static int slip_list(void *news);

static int
rule_list(struct lxlist_type *lxlist_data, void *list,
	  struct x1f4_function_type *function_data, void **input)
{
    int status = 0;
    unsigned count;

    count = function_data->count;
    if (count) {
	const int *args;
	int object_type;
	struct x1f4_dxcast_type dxcast;
	void *miss, *slip[2];

	object_type = lxlist_data->link_g.type;

	args = function_data->args;

	slip[0] = &list;
	slip[1] = &miss;

	miss = &dxcast;

	for (; count; count--) {
	    dxcast.type = *args++;
	    if (dxcast.type == object_type) {
		slip[1] = *input++;
		status = _libx1f4i0_lxlist_a_forward(lxlist_data, NULL, slip);
		slip[1] = &miss;
	    } else {
		copy_miss(&dxcast.data, dxcast.type, *input++);
		status = _libx1f4i0_lxlist_a_forward(lxlist_data, NULL, slip);
	    }
	    if (status) {
		break;
	    }
	}
    }

    return status;
}


static int
slip_list(void *news)
{
    int status;
    void *list, **side;

    side = news;
    list = side[1];
    if (list) {
	status = _libx1f4i0_lxlist_side_list(*side, list);
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxlist_e1centric(void *context, void *output, void **input)
{
    int status;
    struct lxlist_type *lxlist_data;
    void **mind, *news, **side;

    side = context;

    lxlist_data = *side;

    status = lxlist_data->link_v.pick
	(lxlist_data->link_v.data, &mind, slip_list, sizeof(void *) << 1,
	 &news);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	void *list, **seek;

	*mind = news;

	seek = news;

	*seek++ = lxlist_data;

	status = _libx1f4i0_lxlist_line_list(lxlist_data, &list);
	if (status) {
	    *seek = NULL;
	} else {
	    *seek = list;

	    l_LIST(list, output);

	    status = rule_list(lxlist_data, list, *++side, input);
	}
    }

    return status;
}
