/*
 * lxlist-c.c.1.c
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcast.h>
#include <lxlist-inter.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

int
_libx1f4i0_lxlist_c1centric(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE mode;
    int status;
    struct dxlist_type *dxlist_data;
    struct lxlist_type *lxlist_data;
    unsigned size;
    void **side;

    side = context;

    lxlist_data = *side;

    dxlist_data = I_LIST(input[0]);

    mode = I_MODE(input[1]);

    size = dxlist_data->size + 1;
    if (mode < -(X1f4_E4_C_MODE) (int) size
	|| !(mode < (X1f4_E4_C_MODE) (int) size)) {
	status = _libx1f4i0_lxlist_stat_deck(lxlist_data, size, mode);
    } else {
	struct x1f4_function_type *function_data;
	unsigned count;

	if (mode < 0) {
	    mode += size;
	}

	function_data = *++side;

	status = 0;

	count = function_data->count - 2;
	if (count) {
	    const int *args;
	    int object_type;
	    struct x1f4_dxcast_type dxcast;
	    void *miss, *slip[3];

	    object_type = lxlist_data->link_g.type;

	    args = function_data->args + 2;

	    slip[0] = *input;
	    slip[1] = &mode;
	    slip[2] = &miss;

	    miss = &dxcast;

	    input++;

	    for (; count; count--) {
		dxcast.type = *args++;
		if (dxcast.type == object_type) {
		    slip[2] = *++input;
		    status =
			_libx1f4i0_lxlist_l_pending(lxlist_data, NULL, slip);
		    slip[2] = &miss;
		} else {
		    copy_miss(&dxcast.data, dxcast.type, *++input);
		    status =
			_libx1f4i0_lxlist_l_pending(lxlist_data, NULL, slip);
		}
		if (status) {
		    break;
		} else {
		    mode++;
		}
	    }
	}
    }

    return status;
}
