/*
 * lxlist-a.l.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_list.h>
#include <lxlead.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define __HIGH_CLEAR__			1
#define __MISS_CLEAR__			2

#define __HERE_CLEAR__			__HIGH_CLEAR__

#define dxlist(list) \
    ((struct dxlist_type *) (list))
#define lxlist(list) \
    ((struct lxlist_type *) (list))

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_null_list(void *lxlist,
			    struct excase_type **excase, void *dxlist)
{
    int status = 0;
    unsigned size;

    size = dxlist(dxlist)->size;
    if (size) {
	struct excase_type *excase_data;
	struct lxtext_type *lxtext_data;
	void *list;

	lxtext_data = lxlist(lxlist)->link_f.text;

	if (excase) {
	    excase_data = *excase;
	} else {
	    excase_data = NULL;
	}

	list = dxlist(dxlist)->list;
	while (size) {
	    unsigned link;
	    void *data;

	    size--;

#if __HERE_CLEAR__ == __MISS_CLEAR__
	    _libx1f4i0_peek_l4list(list, 0, &data);
#else
	    _libx1f4i0_peek_l4list(list, size, &data);
#endif				/* __HERE_CLEAR__ == __MISS_CLEAR__ */

	    link = byte(data)[4] << 030 | byte(data)[5] << 020
		| byte(data)[6] << 010 | byte(data)[7];
	    if (~link) {
		int (*free) (void *, void *, struct excase_type **,
			     const struct excase_type *);
		struct lxtext_type *lxtext_link;

		lxtext_link = lxtext_data + link;

		if (lxtext_link->lxtype.flags & X1f4_LX_PICK_ACCESS) {
		    free = lxtext_link->lxtype.pick;
		} else {
		    free = lxtext_link->lxtype.free;
		}
		if (free) {
		    int excess;

		    excess = free
			(lxtext_link->lxtype.context,
			 I_USER(byte(data) + 8), &excase_data,
			 lock_excase(dxlist));
		    if (excess) {
			if (status) {
			} else {
			    status = excess;
			}
		    }
		}
	    }

#if __HERE_CLEAR__ == __MISS_CLEAR__
	    if (1) {
		int excess;

		excess = _libx1f4i0_miss_l4list(list, 0);
		if (excess) {
		    excess = _libx1f4i0_lxlist_stat_list(lxlist, excess);
		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
#endif				/* __HERE_CLEAR__ == __MISS_CLEAR__ */
	}

#if __HERE_CLEAR__ == __HIGH_CLEAR__
	if (1) {
	    int excess;

	    excess = _libx1f4i0_high_l4list(list);
	    if (excess) {
		excess = _libx1f4i0_lxlist_stat_list(lxlist, excess);
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
#endif				/* __HERE_CLEAR__ == __HIGH_CLEAR__ */

	if (excase) {
	    *excase = excase_data;
	} else {
	    if (excase_data) {
		status = x1f4_fail_lxlead(excase_data);
	    }
	}

#if __HERE_CLEAR__ == __HIGH_CLEAR__
	dxlist(dxlist)->size = 0;
#endif				/* __HERE_CLEAR__ == __HIGH_CLEAR__ */

#if __HERE_CLEAR__ == __MISS_CLEAR__
	dxlist(dxlist)->size = size;
#endif				/* __HERE_CLEAR__ == __MISS_CLEAR__ */
    }

    return status;
}
