/*
 * lxlist-a.e.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4.h>
#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <integral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <l_list.h>
#if !defined HAVE_LIBx1f4i0
# include <lintegral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxlist-inter.h>
#include <lxlist-types.h>
#if !defined HAVE_LIBx1f4i0
# include <ordinal.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define lxlist(lxlist) \
    ((struct lxlist_type *) (lxlist))

static int make_type(void *, void *, int (*) (void *, const char *, unsigned),
		     unsigned);

static int
make_type(void *lxlist, void *data,
	  int (*push) (void *, const char *, unsigned), unsigned type)
{
    return x1f4_dump_type
	(data, push, type, lxlist(lxlist)->trap_e.eelookup_data);
}


int
_libx1f4i0_lxlist_stat_call(void *lxlist, int mode, unsigned found,
			    unsigned expected, int error)
{
    int status;

    if (error == X1f4_L4LIST_CALL_ERROR) {
	status = _libx1f4i0_lxlist_stat_type(lxlist, mode, found, expected);
    } else {
	status = _libx1f4i0_lxlist_stat_list(lxlist, error);
    }

    return status;
}


int
_libx1f4i0_lxlist_stat_copy(void *lxlist)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push(data, "cannot copy/link/move list for non self inc"
			  "lusion rules say so", 62);
	    if (status) {
		break;
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_deck(void *lxlist, unsigned size, long mode)
{
    int status;

    if (size) {
	status = _libx1f4i0_lxlist_stat_time(lxlist, size, mode);
    } else {
	status = _libx1f4i0_lxlist_stat_null(lxlist);
    }

    return status;
}


int
_libx1f4i0_lxlist_stat_flat(void *lxlist, int mode)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push(data, "numeric type expected for the ", 30);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dintegral(data, push, mode + 1);
		if (status) {
		    break;
		} else {
		    char miss[2];

		    x1f4_extend_ordinal(miss, mode);
		    status = push(data, miss, 2);
		    if (status) {
			break;
		    } else {
			status = push(data, " list element", 13);
			if (status) {
			    break;
			}
		    }
		}
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_free(void *lxlist)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxlist_stat_lead(void *lxlist, unsigned type)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push
		(data, "will not box non referable, non intrinsic object of"
		 " type ", 57);
	    if (status) {
		break;
	    } else {
		status = make_type(lxlist, data, push, type);
		if (status) {
		    break;
		}
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_link(void *lxlist)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxlist_stat_list(void *lxlist, int error)
{
    int status;

    if (error == X1f4_L4LIST_FREE_ERROR) {
	status = _libx1f4i0_lxlist_stat_free(lxlist);
    } else {
	if (error == X1f4_L4LIST_LINK_ERROR) {
	    status = _libx1f4i0_lxlist_stat_link(lxlist);
	} else {
	    if (error == X1f4_L4LIST_MODE_ERROR) {
		status = _libx1f4i0_lxlist_stat_mode(lxlist);
	    } else {
		if (error == X1f4_L4LIST_SIZE_ERROR) {
		    status = _libx1f4i0_lxlist_stat_size(lxlist);
		} else {
		    /*
		     * there are defined more list error conditions...
		     */
		    status = X1f4_EX_CRITICAL;
		}
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxlist_stat_mode(void *lxlist)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push(data, "cannot reallocate memory", 24);
	    if (status) {
		break;
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxlist_stat_null(void *lxlist)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push(data, "empty list", 10);
	    if (status) {
		break;
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_size(void *lxlist)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push(data, "list not empty", 14);
	    if (status) {
		break;
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_time(void *lxlist, unsigned size, long mode)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push(data, "out of valid range (-", 21);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dcardinal(data, push, size);
		if (status) {
		    break;
		} else {
		    status = push(data, " .. ", 4);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_dcardinal(data, push, size - 1);
			if (status) {
			    break;
			} else {
			    status = push(data, ") index (", 9);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_dlintegral
				    (data, push, mode);
				if (status) {
				    break;
				} else {
				    status = push(data, ")", 1);
				    if (status) {
					break;
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_type(void *lxlist, int mode, unsigned found,
			    unsigned expected)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxlist(lxlist)->link_e.data;

	line = lxlist(lxlist)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxlist(lxlist)->link_e.push;
	if (push) {
	    status = push(data, "mismatched type (", 17);
	    if (status) {
		break;
	    } else {
		status = make_type(lxlist, data, push, found);
		if (status) {
		    break;
		} else {
		    status = push(data, " found, ", 8);
		    if (status) {
			break;
		    } else {
			status = make_type(lxlist, data, push, expected);
			if (status) {
			    break;
			} else {
			    status = push(data, " expected) for ", 15);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_dintegral
				    (data, push, mode + 1);
				if (status) {
				    break;
				} else {
				    char miss[2];

				    x1f4_extend_ordinal(miss, mode);
				    status = push(data, miss, 2);
				    if (status) {
					break;
				    } else {
					status = push
					    (data, " list element", 13);
					if (status) {
					    break;
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxlist(lxlist)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
