/*
 * lxlist-a.c.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <l_list.h>
#include <lxlead.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <tcvset.h>

#define break_cycles			0

#define lxlist(list) \
    ((struct lxlist_type *) (list))

int
_libx1f4i0_lxlist_side_list(void *subtext, void *dxlist)
{
    int status;
    unsigned call;

    call = lock_exlist(dxlist)->call;
    if (call ^ 1) {
	int (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);

	lock_exlist(dxlist)->call = call - 1;

	miss = lxlist(subtext)->link_r.miss;
	if (miss) {
	    status = miss
		(lxlist(subtext)->link_r.text, NULL,
		 lock_excase(dxlist));
	} else {
	    status = x1f4_mind_lxlead(NULL, dxlist);
	}
    } else {
	int excess;

	lock_exlist(dxlist)->call = break_cycles;

	status = _libx1f4i0_lxlist_null_list(subtext, NULL, dxlist);

	excess = _libx1f4i0_lxlist_fine_list(subtext, dxlist);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}
