/*
 * lxlist-a.1.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-defs.h>
#include <lxlist-types.h>

static int fini_list(struct lxlist_type *);

static int
fini_list(struct lxlist_type *lxlist_data)
{
    int (*free) (void *, void *), status;
    void *data;

    data = lxlist_data->link_w.data;
    free = lxlist_data->link_w.free;

    status = free(data, lxlist_data->link_f.data);
    if (status) {
	status = FREE_ERROR;
    } else {
	status = free(data, lxlist_data);
	if (status) {
	    status = FREE_ERROR;
	}
    }

    return status;
}


int
x1f4_fini_lxlist(void **lxlist)
{
    return fini_list(*lxlist);
}
