/*
 * lxline-v.v.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_v_class_v(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    struct lxtext_type *lxtext_data;
    void *data;

    lxtext_data = context;

    lxline_data = lxtext_data->text;

    dxline_data = I_LINE(input[1]);

    status = _libx1f4i0_ever_sfnote(dxline_data->line, &data);
    if (status) {
	status = _libx1f4i0_lxline_stat_line(lxline_data, status);
    } else {
	unsigned type;

	type = byte(data)[0] << 030 | byte(data)[1] << 020
	    | byte(data)[2] << 010 | byte(data)[3];
	if (type != lxtext_data->lxtype.code) {
	    status = _libx1f4i0_lxline_stat_ends
		(lxline_data, 0, type, lxtext_data->lxtype.code);
	} else {
	    void *post;

	    post = I_USER(byte(data) + 8);

	    status = _libx1f4i0_slip_sfnote(dxline_data->line);
	    if (status) {
		status = _libx1f4i0_lxline_stat_line(lxline_data, status);
	    } else {
		dxline_data->size--;

		if (0) {
		} else {
		    status = lxtext_data->lxtype.push
			(lxtext_data->lxtype.context,
			 input[0], post, lock_excase(dxline_data));
		}
	    }
	}
    }

    return status;
}
