/*
 * lxline-u.r.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <stddef.h>

#include <e4.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_r_class_u(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;

    dxline_data = I_LINE(input[0]);

    do {
	struct lxtext_type *lxtext_data;

	lxtext_data = context;

	status = _libx1f4i0_lxline_d_logique(lxtext_data->text, output, input);
	if (status) {
	} else {
	    status = _libx1f4i0_lxline_p_class_u(context, output, input);
	}
    } while (0);

    return status;
}
