/*
 * lxline-t.r.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <stddef.h>

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_r_class_t(void *context, void *output, void **input)
{
    X1f4_E4_C_TEXT fail;
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    struct lxtext_type *lxtext_data;
    void *data;

    dxline_data = I_LINE(input[0]);

    lxtext_data = context;

    lxline_data = lxtext_data->text;

    fail = I_TEXT(input[1]);

    status = _libx1f4i0_find_sfnote(dxline_data->line, fail, &data);
    if (status) {
	int excess,
	    (*free) (void *, void *, struct excase_type **,
		     const struct excase_type *);
	struct lxtext_type *lxtext_link;
	unsigned link;
	void *text;

	link = byte(data)[4] << 030 | byte(data)[5] << 020
	    | byte(data)[6] << 010 | byte(data)[7];

	lxtext_link = (struct lxtext_type *) lxline_data->link_f.text + link;

	if (~link) {
	    free = lxtext_link->lxtype.free;
	    if (free) {
		text = I_USER(byte(data) + 8);
	    } else {
		text = NULL;
	    }
	} else {
	    free = NULL;
	    text = NULL;
	}

	if (0) {
	} else {
	    status = _libx1f4i0_pass_sfnote(dxline_data->line, fail);
	    if (status) {
		status = _libx1f4i0_lxline_stat_line(lxline_data, status);
	    } else {
		dxline_data->size--;

		status = _libx1f4i0_lxline_p_class_t(context, output, input);
	    }

	    if (free) {
		excess = free
		    (lxtext_link->lxtype.context, text, NULL,
		     lock_excase(dxline_data));
		if (excess) {
		    status = excess;
		}
	    }
	}
    } else {
	status = _libx1f4i0_lxline_stat_miss(lxline_data, fail);
    }

    return status;
}
