/*
 * lxline-t.a.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_a_class_t(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    struct lxtext_type *lxtext_data;
    void *data, *slip;

    lxtext_data = context;

    dxline_data = I_LINE(input[0]);

    lxline_data = lxtext_data->text;

    status = lxtext_data->lxtype.copy
	(lxtext_data->lxtype.context, NULL, &slip,
	 I_TEXT(input[2]), lock_excase(dxline_data));
    if (status) {
    } else {
	if (0) {
	} else {
	    status = _libx1f4i0_post_sfnote
		(dxline_data->line, I_TEXT(input[1]),
		 sizeof(struct fxdata_type) + 8, &data);
	    if (status) {
		int excess;

		if (status == X1f4_SFNOTE_EVER_MATCH) {
		    status = 0;
		} else {
		    status = _libx1f4i0_lxline_stat_text
			(lxtext_data->text, status, I_TEXT(input[1]));
		}

		excess = lxtext_data->lxtype.free
		    (lxtext_data->lxtype.context, slip, NULL,
		     lock_excase(dxline_data));
		if (excess) {
		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    } else {
#define type				X1f4_E4_TEXT

		unsigned link;

		byte(data)[0] = type >> 030;
		byte(data)[1] = type >> 020;
		byte(data)[2] = type >> 010;
		byte(data)[3] = type >> 000;

		link = lxtext_data
		    - ((struct lxtext_type *) lxline_data->link_f.text);

		byte(data)[4] = link >> 030;
		byte(data)[5] = link >> 020;
		byte(data)[6] = link >> 010;
		byte(data)[7] = link >> 000;

		dxline_data->size++;

		l_TEXT(slip, byte(data) + 8);

#undef type
	    }
	}
    }

    return status;
}
