/*
 * lxline-s.d.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_d_sequent(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxline_type *dxline_data;
	struct lxline_type *lxline_data;
	struct lxtext_type *lxtext_data;
	void *data;

	lxtext_data = context;

	dxline_data = I_LINE(input[0]);

	lxline_data = lxtext_data->text;

	if (0) {
	} else {
	    status = _libx1f4i0_post_sfnote
		(dxline_data->line, I_TEXT(input[1]),
		 sizeof(struct fxdata_type) + 8, &data);
	    if (status) {
		if (status == X1f4_SFNOTE_EVER_MATCH) {
		    status = 0;
		} else {
		    status = _libx1f4i0_lxline_stat_line(lxline_data, status);
		}
	    } else {
		unsigned link, type;

		type = lxtext_data->lxtype.code;

		byte(data)[0] = type >> 030;
		byte(data)[1] = type >> 020;
		byte(data)[2] = type >> 010;
		byte(data)[3] = type >> 000;

		link = lxtext_data
		    - ((struct lxtext_type *) lxline_data->link_f.text);

		byte(data)[4] = link >> 030;
		byte(data)[5] = link >> 020;
		byte(data)[6] = link >> 010;
		byte(data)[7] = link >> 000;

		status = lxtext_data->lxtype.node
		    (lxtext_data->lxtype.context,
		     (void **) (byte(data) + 8), I_USER(input[2]),
		     lock_excase(dxline_data));
		if (status) {
		    _libx1f4i0_pass_sfnote
			(dxline_data->line, I_TEXT(input[1]));
		} else {
		    dxline_data->size++;
		}
	    }
	}
    } while (0);

    return status;
}
