/*
 * lxline-s.b.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_b_sequent(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    struct lxtext_type *lxtext_data;
    void *slip, *data;

    lxtext_data = context;

    dxline_data = I_LINE(input[0]);

    status = _libx1f4i0_find_sfnote
	(dxline_data->line, I_TEXT(input[1]), &data);
    if (status) {
	int (*free) (void *, void *, struct excase_type **,
		     const struct excase_type *);
	struct lxline_type *lxline_data;
	struct lxtext_type *lxtext_link, *lxtext_slip;
	unsigned link;

	slip = data;

	lxtext_data = context;

	dxline_data = I_LINE(input[0]);

	lxline_data = lxtext_data->text;

	lxtext_link = lxline_data->link_f.text;

	link = byte(slip)[4] << 030 | byte(slip)[5] << 020
	    | byte(slip)[6] << 010 | byte(slip)[7];

	lxtext_slip = lxtext_link;

	if (~link) {
	    lxtext_slip += link;

	    free = lxtext_slip->lxtype.free;
	    if (free) {
		slip = I_USER(byte(slip) + 8);
	    }
	} else {
	    free = NULL;
	}

	if (0) {
	} else {
	    unsigned link, type;

	    type = lxtext_data->lxtype.code;

	    byte(data)[0] = type >> 030;
	    byte(data)[1] = type >> 020;
	    byte(data)[2] = type >> 010;
	    byte(data)[3] = type >> 000;

	    link = lxtext_data - lxtext_link;

	    byte(data)[4] = link >> 030;
	    byte(data)[5] = link >> 020;
	    byte(data)[6] = link >> 010;
	    byte(data)[7] = link >> 000;

	    status = lxtext_data->lxtype.node
		(lxtext_data->lxtype.context,
		 (void **) (byte(data) + 8), I_USER(input[2]),
		 lock_excase(dxline_data));
	    if (status) {
		_libx1f4i0_pass_sfnote(dxline_data->line, I_TEXT(input[1]));
	    }

	    if (free) {
		int excess;

		excess = free
		    (lxtext_slip->lxtype.context,
		     (void *) slip, NULL, lock_excase(dxline_data));
		if (excess) {
		    status = excess;
		}
	    }
	}
    } else {
	status = _libx1f4i0_lxline_stat_miss
	    (lxtext_data->text, I_TEXT(input[1]));
    }

    return status;
}
