/*
 * lxline-p.t.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxcall.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <trans.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#define dxline(line) \
    ((struct dxline_type *) (line))
#define lxline(line) \
    ((struct lxline_type *) (line))

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxline_t_pending(void *context, void *output, void **input)
{
    X1f4_E4_C_TEXT fail;
    int status;
    struct lxline_type *lxline_data;
    void *data;

    lxline_data = context;

    fail = I_TEXT(input[1]);

    status = _libx1f4i0_find_sfnote
	(dxline(I_LINE(input[0]))->line, fail, &data);
    if (status) {
	const char *type;
	unsigned link;

	status = 0;

	link = byte(data)[4] << 030 | byte(data)[5] << 020
	    | byte(data)[6] << 010 | byte(data)[7];
	if (~link) {
	    type = ((struct lxtext_type *) lxline_data->link_f.text
		    + link)->lxtype.name;
	} else {
	    type = x1f4_c1_empty_string;

	    if (lxline_data->link_v.link) {
		struct trans_type trans;

		trans.data = lxline_data->link_v.data;
		trans.free = lxline_data->link_v.free;
		trans.link = lxline_data->link_v.link;
		trans.mode = lxline_data->link_v.mode;

		link = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];

		status = _libx1f4i0_lxcall_line_type
		    (&type, link, lxline_data->trap_e.eelookup_data,
		     &trans);
		if (status) {
		    status = _libx1f4i0_lxline_stat_link(lxline_data);
		}
	    }
	}

	if (status) {
	} else {
	    l_TEXT((char *) type, output);
	}
    } else {
	status = _libx1f4i0_lxline_stat_miss(lxline_data, fail);
    }

    return status;
}
