/*
 * lxline-p.l.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <string.h>

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_l_pending(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    dxline_data = I_LINE(input[0]);

    lxline_data = lxtext_data->text;

    if (0) {
    } else {
	const char *lift;
	unsigned size;
	void *data;

	status = _libx1f4i0_llxq_sfnote
	    (dxline_data->line, I_TEXT(input[1]), &data, &lift, &size);
	if (status) {
	    void *fine;

	    status = lxline_data->link_m.link
		(lxline_data->link_m.data, &fine, size + 1);
	    if (status) {
		status = _libx1f4i0_lxline_stat_link(lxline_data);
	    } else {
		memcpy(fine, lift, size + 1);
		status = lxtext_data->lxtype.push
		    (lxline_data, input[2], fine, lock_excase(dxline_data));
		if (status) {
		    lxline_data->link_m.free(lxline_data->link_m.data, fine);
		} else {
		    l_MODE(1, output);
		}
	    }
	} else {
	    if (0) {
	    } else {
		l_MODE(0, output);
		if (1) {
		    status = 0;
		}
	    }
	}
    }

    return status;
}
