/*
 * lxline-p.i.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#define dxline(line) \
    ((struct dxline_type *) (line))

int
_libx1f4i0_lxline_i_pending(void *context, void *output, void **input)
{
    X1f4_E4_C_TEXT fail;
    int status;
    void *data;

    fail = I_TEXT(input[1]);

    status = _libx1f4i0_find_sfnote
	(dxline(I_LINE(input[0]))->line, fail, &data);
    if (status) {
	unsigned link;

	link = byte(data)[0] << 030 | byte(data)[1] << 020
	    | byte(data)[2] << 010 | byte(data)[3];

	l_MODE(link, output);

	status = 0;
    } else {
	status = _libx1f4i0_lxline_stat_miss(context, fail);
    }

    return status;
}
