/*
 * lxline-p.d.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define byte(miss)			((unsigned char *) (miss))

typedef struct drop_type {
    int success;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
} drop_type;

static int drop_note(void *, void *);

static int
drop_note(void *text, void *data)
{
    int status = 0;

    do {
	struct dxline_type *dxline_data;
	unsigned link;

	dxline_data = ((struct drop_type *) text)->dxline_data;

	link = byte(data)[4] << 030 | byte(data)[5] << 020
	    | byte(data)[6] << 010 | byte(data)[7];
	if (~link) {
	    int (*free) (void *, void *, struct excase_type **,
			 const struct excase_type *);
	    struct lxtext_type *lxtext_link;

	    lxtext_link =
		((struct lxtext_type *)
		 ((struct drop_type *) text)->lxline_data->link_f.text) + link;

	    free = lxtext_link->lxtype.free;
	    if (free) {
		status = free
		    (lxtext_link->lxtype.context, I_USER(byte(data) + 8), NULL,
		     lock_excase(dxline_data));
		if (status) {
		    ((struct drop_type *) text)->success = status;
		    if (1) {
			break;
		    }
		}
	    }
	}

	dxline_data->size--;
    } while (0);

    return status;
}


int
_libx1f4i0_lxline_d_pending(void *context, void *output, void **input)
{
    X1f4_E4_C_TEXT fail;
    int status;
    struct drop_type drop;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;

    dxline_data = I_LINE(input[0]);

    lxline_data = context;

    fail = I_TEXT(input[1]);

    drop.lxline_data = lxline_data;
    drop.dxline_data = dxline_data;

    drop.success = 0;

    status = _libx1f4i0_drop_sfnote(dxline_data->line, fail, &drop, drop_note);
    if (status) {
	if (status == X1f4_SFNOTE_MISS_CLASS) {
	    status = _libx1f4i0_lxline_stat_miss(lxline_data, fail);
	} else {
	    status = _libx1f4i0_lxline_stat_line(lxline_data, status);
	}
    } else {
	status = drop.success;
    }

    return status;
}
